//
//  HomeViewController.swift
//  EPOS
//
//  Created by Apple on 12/07/21.
//

import UIKit

class HomeViewController: UIViewController {
    
    //MARK: IBOutlets
    @IBOutlet weak var constTableHeight:NSLayoutConstraint!
    @IBOutlet weak var collectionHome:UICollectionView!
    @IBOutlet weak var lblPageCount:UILabel!
    @IBOutlet weak var lblFailedOrderCount:UILabel!
    @IBOutlet weak var btnNextPage:UIButton!
    @IBOutlet weak var lblShowTable:UILabel!
    @IBOutlet weak var btnPreviousPage:UIButton!
    @IBOutlet weak var btnOrderHistory:UIButton!
    @IBOutlet weak var btnRefresh:UIButton!
    @IBOutlet weak var collectionFloor:UICollectionView!
    @IBOutlet weak var constFloorWidth:NSLayoutConstraint!
    @IBOutlet weak var collectionTable:UICollectionView!
    @IBOutlet weak var collectionAllOrders:UICollectionView!
    @IBOutlet weak var collectionOnlineOrders:UICollectionView!
    @IBOutlet weak var collectionWaitingOrders:UICollectionView!
    @IBOutlet weak var collectionCollectionOrders:UICollectionView!
    @IBOutlet weak var collectionDeliveryOrders:UICollectionView!
    @IBOutlet weak var scrollOrders:UIScrollView!
    @IBOutlet weak var lblShowAll:UILabel!
    @IBOutlet weak var lblAllActiveOrder:UILabel!
    @IBOutlet weak var lblWaiting:UILabel!
    @IBOutlet weak var lblWaitingActiveOrder:UILabel!
    @IBOutlet weak var lblCollection:UILabel!
    @IBOutlet weak var lblCollectionActiveOrder:UILabel!
    @IBOutlet weak var lblDelivery:UILabel!
    @IBOutlet weak var lblDeliveryActiveOrder:UILabel!
    @IBOutlet weak var lblDeliveryLine:UILabel!
    @IBOutlet weak var lblCollectionLine:UILabel!
    @IBOutlet weak var lblWaitingLine:UILabel!
    @IBOutlet weak var lblShowAllLine:UILabel!
    @IBOutlet weak var lblOnlineOrders:UILabel!
    @IBOutlet weak var lblOnlineActiveOrder:UILabel!
    @IBOutlet weak var lblOnlineLine:UILabel!
    @IBOutlet weak var viewForOrders:UIView!
    @IBOutlet weak var viewForActiveOrders:UIView!
    @IBOutlet weak var viewForTables:UIView!
    @IBOutlet weak var viewForRefresh:UIView!
    @IBOutlet weak var viewForPushData:UIView!
    @IBOutlet weak var btnNewOrder:UIButton!
    
    @IBOutlet weak var viewForTheme4:UIView!
    @IBOutlet weak var btnOrderHistoryTheme4:UIButton!
    @IBOutlet weak var collectionOnlineOrdersTheme4:UICollectionView!
    @IBOutlet weak var collectionWaitingOrdersTheme4:UICollectionView!
    @IBOutlet weak var collectionCollectionOrdersTheme4:UICollectionView!
    @IBOutlet weak var collectionDeliveryOrdersTheme4:UICollectionView!
    
    //MARK: Instances
    lazy var arrHomeData = [SideMenuCellData]()
    var parentVC:SideMenuVC!
    weak var delegate:NewOrderDelegate?
    var totalCount = 0
    var collectionCount = 0
    var waitingCount = 0
    var deliveryCount = 0
    var arrFloors = [FloorModel]()
    var selectedFloorIndex = 0
    var selectedOrderTypeIndex:Int?
    lazy var arrNewOrder = [WebOrderModel]()
    lazy var arrCompletedOrder = [WebOrderModel]()
    lazy var arrCurrentOrder = [WebOrderModel]()
    lazy var arrOngoingDeliveryOrders = [OrderModel]()
    lazy var arrOngoingCollectionOrders = [OrderModel]()
    lazy var arrOngoingWaitingOrders = [OrderModel]()
    lazy var arrSearchOngoingOrders = [OrderModel]()
    lazy var arrSelectedOrders = [OrderModel]()
    var selectedOrderType:OrderTypesModel?
    var arrOrderTypeIds = [Int]()
    var dictOrders = NSMutableDictionary()
    var arrOrderSection = [String]()
    var isServeSelected = false
    var selectedTable:TableModel!
    var selectedOrder:OrderModel!
    var selectedOrderRow:Int?
    var selectedOrderSection:Int?
    let horizontalCV = HorizontalCollectionViewLayout()
    var homeTheme = "theme1"
    var orderShownCount = 0
    var orderAvailableCount = 0
    
    //MARK:  ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()
        
        // Do any additional setup after loading the view.
        let column:CGFloat = (AppConstants.ScreenSize.SCREEN_HEIGHT >= 1024) ? 4 : 3
        let width = (self.view.frame.width-40) / column
        let height = (AppConstants.ScreenSize.SCREEN_HEIGHT - (155 + AppConstants.ScreenSize.bottomPadding + AppConstants.ScreenSize.topPadding)) / column
        horizontalCV.itemSize = CGSize(width: width, height: height)
        collectionHome.collectionViewLayout = horizontalCV
        if AppCommonMethods.fetchSiteSettingValue(key: "cloud_system") ?? "" == "no"{
            viewForPushData.isHidden = true
            viewForRefresh.isHidden = true
        }else{
            viewForPushData.isHidden = false
            viewForRefresh.isHidden = false
        }
        if let theme = AppCommonMethods.fetchSiteSettingValue(key: "home_theme"){
            homeTheme = theme
        }
        
        if homeTheme != "theme1"{
            if AppConstants.userData?.permissions?.orderHistory?.actions?.list ?? 0 == 0{
                btnOrderHistory.isHidden = true
            }else{
                btnOrderHistory.isHidden = false
            }
            if AppCommonMethods.fetchSiteSettingValue(key: "is_dinein") ?? "" == "true" && AppConstants.userData?.permissions?.dinein?.actions?.list ?? 0 == 1{
                FetchFloorList()
            }
        }
        self.collectionFloor.alpha = 1
        checkForOrderReset()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        if let theme = AppCommonMethods.fetchSiteSettingValue(key: "home_theme"){
            homeTheme = theme
        }
        if homeTheme == "theme1"{
            fetchCount()
            viewForOrders.isHidden = true
            NotificationCenter.default.addObserver(self, selector: #selector(fetchCount), name: AppConstants.notifications.kCountFetched, object: nil)
        }else{
            reloadOrderData(showLoader: false)
            viewForOrders.isHidden = false
            isServeSelected = false
            arrSelectedOrders.removeAll()
            if AppCommonMethods.fetchSiteSettingValue(key: "is_dinein") ?? "" == "true" && AppConstants.userData?.permissions?.dinein?.actions?.list ?? 0 == 1{
                FetchFloorListFromDB()
                viewForTables.isHidden = false
                NotificationCenter.default.addObserver(self, selector: #selector(FetchFloorList), name: AppConstants.notifications.kTableUpdated, object: nil)
            }else{
                viewForTables.isHidden = true
            }
            if (AppCommonMethods.fetchSiteSettingValue(key: "is_waiting") ?? "" == "true" && AppConstants.userData?.permissions?.waiting?.actions?.list ?? 0 == 1) || (AppCommonMethods.fetchSiteSettingValue(key: "is_collection") ?? "" == "true" && AppConstants.userData?.permissions?.collection?.actions?.list ?? 0 == 1) || (AppCommonMethods.fetchSiteSettingValue(key: "is_delivery") ?? "" == "true" && AppConstants.userData?.permissions?.delivery?.actions?.list ?? 0 == 1) || (AppCommonMethods.fetchSiteSettingValue(key: "is_weborder") ?? "" == "true" && AppConstants.userData?.permissions?.weborder?.actions?.list ?? 0 == 1){
                constTableHeight.constant = ((UIScreen.main.bounds.height - (20 + self.view.safeAreaInsets.top + self.view.safeAreaInsets.bottom))/2) - 65
                btnNewOrder.superview?.isHidden = false
                lblShowTable.superview?.isHidden = false
                viewForActiveOrders.isHidden = false
            }else{
                constTableHeight.constant = UIScreen.main.bounds.height - (20 + self.view.safeAreaInsets.top + self.view.safeAreaInsets.bottom + 75)
                btnNewOrder.superview?.isHidden = true
                lblShowTable.superview?.isHidden = true
                viewForActiveOrders.isHidden = true
            }
            NotificationCenter.default.addObserver(self, selector: #selector(checkForOrderType), name: AppConstants.notifications.kDatabasePushed, object: nil)
        }
        NotificationCenter.default.addObserver(self, selector: #selector(setOrderFailed), name: AppConstants.notifications.kFailedOrder, object: nil)
        NotificationCenter.default.addObserver(self, selector: #selector(UserPulledDatabase), name: AppConstants.notifications.kDatabasePulled, object: nil)
        setOrderFailed()
    }
    
    override func viewWillDisappear(_ animated: Bool) {
        NotificationCenter.default.removeObserver(self, name: AppConstants.notifications.kCountFetched, object: nil)
        NotificationCenter.default.removeObserver(self, name: AppConstants.notifications.kDatabasePushed, object: nil)
        NotificationCenter.default.removeObserver(self, name: AppConstants.notifications.kDatabasePulled, object: nil)
        NotificationCenter.default.removeObserver(self, name: AppConstants.notifications.kTableUpdated, object: nil)
        NotificationCenter.default.removeObserver(self, name: AppConstants.notifications.kFailedOrder, object: nil)
    }
    
    override func viewDidLayoutSubviews() {
//        NSObject.cancelPreviousPerformRequests(withTarget: self, selector: #selector(viewLayout), object: nil)
//        self.perform(#selector(viewLayout), with: nil, afterDelay: 0.1)
        viewLayout()
    }
    
    @objc func viewLayout(){
        print("viewDidLayoutSubviews")
        if homeTheme == "theme1"{
            let column:CGFloat = (AppConstants.ScreenSize.SCREEN_HEIGHT >= 1024) ? 4 : 3
            let cellWidth = (self.view.frame.width-40) / column
            let height = (AppConstants.ScreenSize.SCREEN_HEIGHT - (155 + AppConstants.ScreenSize.bottomPadding + AppConstants.ScreenSize.topPadding)) / column
            self.horizontalCV.itemSize = CGSize(width: cellWidth, height: height)
            self.collectionHome.reloadData()
            self.collectionHome.contentOffset = CGPoint.init(x: self.collectionHome.frame.width * CGFloat((self.collectionHome.currentPage-1)), y: self.collectionHome.contentOffset.y)
        }else{
            let width = self.view.frame.width-40
            self.collectionTable.contentOffset = CGPoint.init(x: width*CGFloat(self.selectedFloorIndex), y: 0)
            self.collectionTable.reloadData()
            if !self.lblShowTable.superview!.isHidden{
                if self.selectedOrderTypeIndex != nil{
                    self.scrollOrders.contentOffset = CGPoint.init(x: width*CGFloat(self.selectedOrderTypeIndex!), y: 0)
                }
                if homeTheme == "theme4"{
                    self.collectionOnlineOrdersTheme4.reloadData()
                    self.collectionWaitingOrdersTheme4.reloadData()
                    self.collectionDeliveryOrdersTheme4.reloadData()
                    self.collectionCollectionOrdersTheme4.reloadData()
                }else{
                    if self.selectedOrderType != nil{
                        if self.selectedOrderType?.id ?? 0 == 6{
                            self.collectionOnlineOrders.reloadData()
                        }else if self.selectedOrderType?.id ?? 0 == 5{
                            self.collectionWaitingOrders.reloadData()
                        }else if self.selectedOrderType?.id ?? 0 == 2{
                            self.collectionCollectionOrders.reloadData()
                        }else{
                            self.collectionDeliveryOrders.reloadData()
                        }
                    }else{
                        self.collectionAllOrders.reloadData()
                    }
                }
            }
        }
    }
    
    //MARK:  ViewController Instance
    static func addToParentView(parentVC:SideMenuVC)->HomeViewController?{
        guard let VC = UIStoryboard.init(name: "SideMenu", bundle: nil).instantiateViewController(withIdentifier: "HomeViewController") as? HomeViewController else {
            return nil
        }
        VC.parentVC = parentVC
        parentVC.addChild(VC)
        parentVC.viewForContainer.addSubview(VC.view)
        VC.view.frame = CGRect.init(x: 0, y: 0, width: parentVC.viewForContainer.frame.width, height: parentVC.viewForContainer.frame.height)
        return VC
    }
    
    //MARK:  Button Actions
    @IBAction func btnNextAction(_ sender:UIButton){
        var offsetX = collectionHome.contentOffset.x
        offsetX = offsetX + collectionHome.frame.width
        collectionHome.contentOffset = CGPoint.init(x: offsetX, y: collectionHome.contentOffset.y)
    }
    
    @IBAction func btnPrevoiusAction(_ sender:UIButton){
        var offsetX = collectionHome.contentOffset.x
        offsetX = offsetX - collectionHome.frame.width
        collectionHome.contentOffset = CGPoint.init(x: offsetX, y: collectionHome.contentOffset.y)
    }
    
    @IBAction func btnNewOrderAction(_ sender:UIButton){
        if let VC = OrderTypeSelectionVc.showPopup(parentVC: self.parentVC){
            VC.delegate = self.parentVC
        }
    }
    
    @IBAction func btnOrderTypeSelectionAction(_ sender:UIButton){
        isServeSelected = false
        arrSelectedOrders.removeAll()
        let width = self.view.frame.width-40
        selectedOrderTypeIndex = arrOrderTypeIds.firstIndex(of: sender.tag)
        if selectedOrderTypeIndex != nil{
            scrollOrders.contentOffset = CGPoint.init(x: width*CGFloat(selectedOrderTypeIndex!), y: 0)
        }else{
            scrollOrders.contentOffset = CGPoint.init(x: 0, y: 0)
        }
    }
    
    @IBAction func btnSelectAllAction(_ sender:UIButton){
        if checkForSelectAll(){
            arrSelectedOrders.removeAll()
        }else{
            if selectedOrderType?.id ?? 0 == 0{
                dictOrders.forEach { key,value in
                    (value as! [OrderModel]).forEach { model in
                        if model.totalPaid ?? 0 >= model.total ?? 0 && model.total ?? 0 > 0{
                            let isContain =  arrSelectedOrders.contains { model2 in
                                return model2.id ?? 0 == model.id ?? 0
                            }
                            if !isContain{
                                arrSelectedOrders.append(model)
                            }
                        }
                    }
                }
            }else if selectedOrderType?.id ?? 0 == 5{
                arrOngoingWaitingOrders.forEach { model in
                    if model.totalPaid ?? 0 >= model.total ?? 0 && model.total ?? 0 > 0{
                        let isContain =  arrSelectedOrders.contains { model2 in
                            return model2.id ?? 0 == model.id ?? 0
                        }
                        if !isContain{
                            arrSelectedOrders.append(model)
                        }
                    }
                }
            }else if selectedOrderType?.id ?? 0 == 2{
                arrOngoingCollectionOrders.forEach { model in
                    if model.totalPaid ?? 0 >= model.total ?? 0 && model.total ?? 0 > 0{
                        let isContain =  arrSelectedOrders.contains { model2 in
                            return model2.id ?? 0 == model.id ?? 0
                        }
                        if !isContain{
                            arrSelectedOrders.append(model)
                        }
                    }
                }
            }else if selectedOrderType?.id ?? 0 == 3{
                arrOngoingDeliveryOrders.forEach { model in
                    if model.totalPaid ?? 0 >= model.total ?? 0 && model.total ?? 0 > 0{
                        let isContain =  arrSelectedOrders.contains { model2 in
                            return model2.id ?? 0 == model.id ?? 0
                        }
                        if !isContain{
                            arrSelectedOrders.append(model)
                        }
                    }
                }
            }
        }
        self.collectionAllOrders.reloadData()
        self.collectionWaitingOrders.reloadData()
        self.collectionDeliveryOrders.reloadData()
        self.collectionCollectionOrders.reloadData()
    }
    
    @IBAction func btnCancelServeAction(_ sender:UIButton){
        isServeSelected = false
        arrSelectedOrders.removeAll()
        self.collectionAllOrders.reloadData()
        self.collectionWaitingOrders.reloadData()
        self.collectionDeliveryOrders.reloadData()
        self.collectionCollectionOrders.reloadData()
    }
    
    @IBAction func btnSelectAction(_ sender:UIButton){
        isServeSelected = true
        self.collectionAllOrders.reloadData()
        self.collectionWaitingOrders.reloadData()
        self.collectionDeliveryOrders.reloadData()
        self.collectionCollectionOrders.reloadData()
    }
    
    @IBAction func btnBackOrderAction(_ sender:UIButton){
        var model:OrderModel!
        if self.selectedOrderType?.id ?? 0 == 0{
            model = (dictOrders[arrOrderSection[Int(sender.accessibilityIdentifier ?? "") ?? 0]] as! [OrderModel])[sender.tag]
        }else{
            if self.selectedOrderType?.id ?? 0 == 3{
                model = arrOngoingDeliveryOrders[sender.tag]
            }else if self.selectedOrderType?.id ?? 0 == 2{
                model = arrOngoingCollectionOrders[sender.tag]
            }else if self.selectedOrderType?.id ?? 0 == 5{
                model = arrOngoingWaitingOrders[sender.tag]
            }
        }
        model.isBackEnabled = false
        self.collectionAllOrders.reloadData()
        self.collectionWaitingOrders.reloadData()
        self.collectionDeliveryOrders.reloadData()
        self.collectionCollectionOrders.reloadData()
    }
    
    @IBAction func btnReadyToCollectAction(_ sender:UIButton){
        if self.selectedOrderType?.id ?? 0 == 0{
            selectedOrder = (dictOrders[arrOrderSection[Int(sender.accessibilityIdentifier ?? "") ?? 0]] as! [OrderModel])[sender.tag]
        }else{
            if self.selectedOrderType?.id ?? 0 == 3{
                selectedOrder = arrOngoingDeliveryOrders[sender.tag]
            }else if self.selectedOrderType?.id ?? 0 == 2{
                selectedOrder = arrOngoingCollectionOrders[sender.tag]
            }else if self.selectedOrderType?.id ?? 0 == 5{
                selectedOrder = arrOngoingWaitingOrders[sender.tag]
            }
        }
        var setting = AlertSetting()
        if selectedOrder.orderTypeId ?? 0 == 2{
            setting.alertMessage = AppConstants.GlobalAlert.ALERT_MARK_ORDER_RTC
        }else{
            setting.alertMessage = AppConstants.GlobalAlert.ALERT_MARK_ORDER_OTW
        }
        setting.type = .kReadyToCollect
        if let VC = AlertViewController.showPopup(parentVC: self.parentVC, setting: setting){
            VC.delegate = self
        }
    }
    
    @IBAction func btnCollectedAction(_ sender:UIButton){
        if self.selectedOrderType?.id ?? 0 == 0{
            selectedOrder = (dictOrders[arrOrderSection[Int(sender.accessibilityIdentifier ?? "") ?? 0]] as! [OrderModel])[sender.tag]
        }else{
            if self.selectedOrderType?.id ?? 0 == 3{
                selectedOrder = arrOngoingDeliveryOrders[sender.tag]
            }else if self.selectedOrderType?.id ?? 0 == 2{
                selectedOrder = arrOngoingCollectionOrders[sender.tag]
            }else if self.selectedOrderType?.id ?? 0 == 5{
                selectedOrder = arrOngoingWaitingOrders[sender.tag]
            }
        }
        var setting = AlertSetting()
        if selectedOrder.orderTypeId ?? 0 == 2{
            setting.alertMessage = AppConstants.GlobalAlert.ALERT_MARK_ORDER_COLLECTED
        }else if selectedOrder.orderTypeId ?? 0 == 5{
            setting.alertMessage = AppConstants.GlobalAlert.ALERT_MARK_ORDER_SERVED
        }else{
            setting.alertMessage = AppConstants.GlobalAlert.ALERT_MARK_ORDER_DELIVERED
        }
        setting.type = .kMarkAsCollect
        if let VC = AlertViewController.showPopup(parentVC: self.parentVC, setting: setting){
            VC.delegate = self
        }
    }
    
    @IBAction func btnViewOrderAction(_ sender:UIButton){
        if selectedOrderType?.id ?? 0 == 6{
            var model:WebOrderModel!
            if sender.accessibilityIdentifier ?? "" == "0"{
                model = arrNewOrder[sender.tag]
            }else if sender.accessibilityIdentifier ?? "" == "1"{
                model = arrCurrentOrder[sender.tag]
            }else{
                model = arrCompletedOrder[sender.tag]
            }
            selectedOrderSection = Int(sender.accessibilityIdentifier ?? "") ?? 0
            selectedOrderRow = sender.tag
            if sender.accessibilityIdentifier ?? "" == "0"{
                if let _ = OrderDetailVC.addToParentView(parentVC: self.parentVC, orderId: model.id ?? 0, orderType: model.orderType ?? ""){
                }
            }else{
                let model = arrCurrentOrder[selectedOrderRow!]
                var settings = AlertSetting()
                if (model.orderType ?? "").lowercased() == "delivery"{
                    settings.alertMessage = AppConstants.GlobalAlert.ALERT_MARK_ORDER_DELIVERED
                    settings.alertTitle =  AppConstants.GlobalAlert.ALERT_DELIVERED_TITLE
                }else if (model.orderType ?? "").lowercased() == "pickup"{
                    settings.alertMessage = AppConstants.GlobalAlert.ALERT_MARK_ORDER_COLLECTED
                    settings.alertTitle =  AppConstants.GlobalAlert.ALERT_COLLECTED_TITLE
                }else{
                    settings.alertMessage = AppConstants.GlobalAlert.ALERT_MARK_ORDER_RTS
                    settings.alertTitle =  AppConstants.GlobalAlert.ALERT_RTS_TITLE
                }
                settings.type = .kDeliverOrder
                if let VC = AlertViewController.showPopup(parentVC: self.parentVC, setting: settings){
                    VC.delegate = self
                }
            }
        }else{
            var model:OrderModel!
            if self.selectedOrderType?.id ?? 0 == 0{
                model = (dictOrders[arrOrderSection[Int(sender.accessibilityIdentifier ?? "") ?? 0]] as! [OrderModel])[sender.tag]
            }else{
                if self.selectedOrderType?.id ?? 0 == 3{
                    model = arrOngoingDeliveryOrders[sender.tag]
                }else if self.selectedOrderType?.id ?? 0 == 2{
                    model = arrOngoingCollectionOrders[sender.tag]
                }else if self.selectedOrderType?.id ?? 0 == 5{
                    model = arrOngoingWaitingOrders[sender.tag]
                }
            }
            if model.totalPaid ?? 0 >= (model.total ?? 0) && model.total ?? 0 > 0{
                model.isBackEnabled = true
                self.collectionAllOrders.reloadData()
                self.collectionWaitingOrders.reloadData()
                self.collectionDeliveryOrders.reloadData()
                self.collectionCollectionOrders.reloadData()
            }else{
                if let VC = CreateOrderVC.instance(){
                    VC.orderId = model.id ?? 0
                    let orderType = OrderTypesModel.init()
                    orderType.id = model.orderTypeId
                    orderType.type = model.orderType
                    VC.orderData = AppCommonMethods.Copy(of: model) ?? model
                    VC.orderType = orderType
                    if model.splitCount ?? 0 > 0 || self.checkOrderSplite(orderData: model){
                        if let VC = SplitOrderVC.instance(){
                            VC.orderType = orderType
                            VC.orderData = AppCommonMethods.Copy(of: model) ?? model
                            self.parentVC.navigationController?.pushViewController(VC, animated: true)
                        }
                    }else{
                        if let VC = OrderReviewVC.instance(){
                            VC.orderType = orderType
                            VC.orderData = AppCommonMethods.Copy(of: model) ?? model
                            self.parentVC.navigationController?.pushViewController(VC, animated: true)
                        }
                    }
                    self.parentVC.navigationController?.viewControllers.insert(VC, at: self.parentVC.navigationController!.viewControllers.count - 1)
                }
            }
        }
    }
    
    @IBAction func btnMarkServedAllAction(_ sender:UIButton){
        if arrSelectedOrders.count > 0{
            var setting = AlertSetting()
            setting.alertMessage = AppConstants.GlobalAlert.ALERT_MARK_ALLORDER_SERVED
            if let VC = AlertViewController.showPopup(parentVC: self.parentVC, setting: setting){
                VC.delegate = self
            }
        }
    }
    
    @IBAction func btnMarkServedAction(_ sender:UIButton){
        if let table = arrFloors[selectedFloorIndex].tableData?[sender.tag]{
            if table.locked  && AppConstants.userData?.id ?? 0 != table.updaterId{
                AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_TABLE_BUSY)
                return
            }
            if (table.tableStatus?.status ?? "").lowercased() == "order taken"{
                if let status = CoreDataHelper.shared.fetchTableStatusData(name: "served").first{
                    AppCommonMethods.SaveTable(table: table, statusId: status.id)
                    table.tableStatusId = status.id ?? 0
                    SQLiteManage.updateTableStatus(tableId: table.id ?? 0, statusId: status.id)
                }else{
                    AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_NO_TABLESTATUS)
                }
            }else{
                if table.lastOrderId ?? 0 == 0 || (table.tableStatus?.status ?? "").lowercased() == "vacant"{
                    if let VC = NewDineInOrderVC.showPopup(parentVC: parentVC, table: table){
                        VC.delegate = self
                    }
                }else{
                    if let order = SQLiteManage.fetchOrderDataById(orderId: table.lastOrderId ?? 0){
                        if (table.tableStatus?.status ?? "").lowercased() == "taking order"{
                            if AppCommonMethods.fetchSiteSettingValue(key: "cancel_order_password_enable") ?? "" == "true"{
                                var setting = AlertSetting()
                                setting.alertTitle = AppConstants.GlobalAlert.ALERT_ENTER_PASSWORD
                                setting.alertMessage = AppConstants.GlobalAlert.ALERT_ENTER_PASSWORD_CANCELORDER
                                setting.textPlcaeholder = "password"
                                setting.type = .kEnterUserPassword
                                setting.textType = .default
                                if let VC = AlertViewController.showPopup(parentVC: self.parentVC, setting: setting){
                                    VC.delegate = self
                                }
                            }else{
                                var setting = AlertSetting()
                                setting.alertMessage = AppConstants.GlobalAlert.ALERT_CANCEL_ORDER
                                setting.alertTitle = AppConstants.GlobalAlert.ALERT_CANCEL_ORDER_TITLE
                                setting.type = .kRejectOrder
                                if let VC = AlertViewController.showPopup(parentVC: self.parentVC, setting: setting){
                                    VC.delegate = self
                                }
                            }
                            selectedTable = table
                            selectedOrder = order
                        }else{
                            self.performOrderAction(table: table, order: order)
                        }
                    }else{
                        self.FetchOrderDetail(table: table)
                    }
                }
            }
        }
        self.collectionTable.reloadData()
    }
    
    @IBAction func btnRefreshAction(_ sender:UIButton){
        let order = SQLiteManage.fetchFailedOrdersData()
        if order.count > 0{
            AppCommonMethods.startProgressBar(strMessage: "Pushing data\nto the server...")
            BGAPIExecution.shared.allDataPushed = {
                DispatchQueue.main.async {
                    AppCommonMethods.stopProgressBar()
                    self.reloadOrderData()
                    self.FetchFloorList()
                }
            }
            BGAPIExecution.shared.AddOrdersToQueue(arr: order)
        }else{
            reloadOrderData()
            FetchFloorList()
        }
    }
    
    @IBAction func btnOrderHistoryAction(_ sender:UIButton){
        self.view.endEditing(true)
        if let _ = OrderHistoryVC.addToParentView(parentVC: self.parentVC, isWebOrder: (selectedOrderType?.id ?? 0 == 6), isFromOrders: true){
        }
    }
    
    @IBAction func btnShowHideTableAction(_ sender:UIButton){
        self.view.endEditing(true)
        if constTableHeight.constant == 0{
            if !self.btnNewOrder.superview!.isHidden{
                constTableHeight.constant = ((UIScreen.main.bounds.height - (20 + self.view.safeAreaInsets.top + self.view.safeAreaInsets.bottom))/2) - 65
            }else{
                constTableHeight.constant = UIScreen.main.bounds.height - (20 + self.view.safeAreaInsets.top + self.view.safeAreaInsets.bottom + 75)
            }
            lblShowTable.text = "Hide Table"
        }else{
            constTableHeight.constant = 0
            lblShowTable.text = "Show Table"
        }
        UIView.animate(withDuration: 0.5) {
            if self.collectionFloor.alpha == 0{
                self.collectionFloor.alpha = 1
            }else{
                self.collectionFloor.alpha = 0
            }
            self.view.layoutIfNeeded()
        }
    }
    
    @IBAction func btnPushDataAction(_ sender:UIButton){
        self.view.endEditing(true)
        BGAPIExecution.shared.allDataPushed = {
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                if !self.lblShowTable.superview!.isHidden{
                    self.checkForOrderType()
                }
                self.collectionTable.reloadData()
            }
        }
        BGAPIExecution.shared.fetchAllOfflineOrders()
        //RealmManager().fetchAllOrders()
    }
    
    //MARK: General Methods
    @objc func setOrderFailed(){
        DispatchQueue.main.async {
            let failedCount = SQLiteManage.fetchCountOfTable(whereString: "WHERE failed = 1 AND business_id = \(AppConstants.businessData?.id ?? 0)", tableName: "Orders")
            if failedCount >= 1 && AppConstants.DataSyncMode == "Auto"{
                self.btnRefresh.superview?.backgroundColor = AppConstants.Colors.kAppThemeDarkRedColor
                self.lblFailedOrderCount.text = "\(failedCount)"
                self.lblFailedOrderCount.isHidden = false
            }else{
                self.btnRefresh.superview?.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
                self.lblFailedOrderCount.isHidden = true
            }
        }
    }
    
    func performOrderAction(table:TableModel, order:OrderModel){
        if (table.tableStatus?.status ?? "").lowercased() == "served"{
            if let VC = CreateOrderVC.instance(){
                VC.orderId = order.id ?? 0
                let arr = AppConstants.arrOrderTypes.filter({ model in
                    return model.id ?? 0 == 1
                })
                if arr.count > 0{
                    VC.orderType = arr[0]
                }
                VC.orderData = AppCommonMethods.Copy(of: order) ?? order
                if order.splitCount ?? 0 > 0 || self.checkOrderSplite(orderData: order){
                    if let VC = SplitOrderVC.instance(){
                        if arr.count > 0{
                            VC.orderType = arr[0]
                        }
                        VC.orderData = AppCommonMethods.Copy(of: order) ?? order
                        self.navigationController?.pushViewController(VC, animated: true)
                    }
                }else{
                    if let VC = OrderReviewVC.instance(){
                        if arr.count > 0{
                            VC.orderType = arr[0]
                        }
                        VC.selectedTable = table
                        VC.orderData = AppCommonMethods.Copy(of: order) ?? order
                        self.navigationController?.pushViewController(VC, animated: true)
                    }
                }
                self.navigationController?.viewControllers.insert(VC, at: self.navigationController!.viewControllers.count - 1)
            }
        }else{
            if Reachabilities.shared.isConnectedToNetwork() && AppConstants.DataSyncMode == "Auto"{
                if let status = CoreDataHelper.shared.fetchTableStatusData(name: "vacant").first{
                    //AppCommonMethods.startProgressBar()
                    order.orderStatusId = 5
                    AppCommonMethods.SaveTable(table: table, statusId: status.id)
                    table.tableStatusId = status.id ?? 0
                    order.table = table
                    SQLiteManage.updateTableStatus(tableId: table.id ?? 0, statusId: status.id, lastOrderId: 0, lastOrderTotal: 0, lastOrderTime: "", offline: 1)
                    BGAPIExecution.shared.orderSaved = { orderId, message in
                        DispatchQueue.main.async {
                            AppCommonMethods.stopProgressBar()
                            print("Order \(orderId) Saved To Server")
                            self.collectionTable.reloadData()
                        }
                    }
                    BGAPIExecution.shared.AddOrderToQueue(order: order)
                    self.collectionTable.reloadData()
                }else{
                    AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_NO_TABLESTATUS)
                }
            }else{
                if let status = CoreDataHelper.shared.fetchTableStatusData(name: "vacant").first{
                    AppCommonMethods.SaveTable(table: table, statusId: status.id)
                    table.tableStatusId = status.id ?? 0
                    order.orderStatusId = 5
                    SQLiteManage.updateTableStatus(tableId: table.id ?? 0, statusId: status.id, lastOrderId: 0, lastOrderTotal: 0, lastOrderTime: "", offline: 1)
                    SQLiteManage.SaveOrderIntoDatabase(order: order, updated: 1)
                }else{
                    AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_NO_TABLESTATUS)
                }
            }
        }
    }
    
    @objc func UserPulledDatabase(){
        if let theme = AppCommonMethods.fetchSiteSettingValue(key: "home_theme"){
            homeTheme = theme
        }
        if AppCommonMethods.fetchSiteSettingValue(key: "cloud_system") ?? "" == "no"{
            viewForPushData.isHidden = true
            viewForRefresh.isHidden = true
        }else{
            viewForPushData.isHidden = false
            viewForRefresh.isHidden = false
        }
        if homeTheme == "theme1"{
            fetchCount()
            viewForOrders.isHidden = true
        }else{
            viewForOrders.isHidden = false
            if (AppCommonMethods.fetchSiteSettingValue(key: "is_waiting") ?? "" == "true" && AppConstants.userData?.permissions?.waiting?.actions?.list ?? 0 == 1) || (AppCommonMethods.fetchSiteSettingValue(key: "is_collection") ?? "" == "true" && AppConstants.userData?.permissions?.collection?.actions?.list ?? 0 == 1) || (AppCommonMethods.fetchSiteSettingValue(key: "is_delivery") ?? "" == "true" && AppConstants.userData?.permissions?.delivery?.actions?.list ?? 0 == 1) || (AppCommonMethods.fetchSiteSettingValue(key: "is_weborder") ?? "" == "true" && AppConstants.userData?.permissions?.weborder?.actions?.list ?? 0 == 1){
                constTableHeight.constant = ((UIScreen.main.bounds.height - (20 + self.view.safeAreaInsets.top + self.view.safeAreaInsets.bottom))/2) - 65
                btnNewOrder.superview?.isHidden = false
                lblShowTable.superview?.isHidden = false
                viewForActiveOrders.isHidden = false
            }else{
                constTableHeight.constant = UIScreen.main.bounds.height - (20 + self.view.safeAreaInsets.top + self.view.safeAreaInsets.bottom + 75)
                btnNewOrder.superview?.isHidden = true
                lblShowTable.superview?.isHidden = true
                viewForActiveOrders.isHidden = true
            }
            if AppCommonMethods.fetchSiteSettingValue(key: "is_dinein") ?? "" == "true" && AppConstants.userData?.permissions?.dinein?.actions?.list ?? 0 == 1{
                FetchFloorList()
                viewForTables.isHidden = false
            }else{
                viewForTables.isHidden = true
            }
            reloadOrderData()
        }
    }
    
    func checkOrderSplite(orderData:OrderModel)->Bool{
        var isSplited = false
        for model in orderData.arrProducts{
            if model.orderSplitId ?? 0 != 0{
                isSplited = true
                break
            }
        }
        return isSplited
    }
    
    func checkForSelectAll()->Bool{
        var isSelectAll = true
        if selectedOrderType?.id ?? 0 == 0{
            for (_,value) in dictOrders {
                if let arr = value as? [OrderModel]{
                    for order in arr{
                        let index = self.arrSelectedOrders.firstIndex(where: { (model) -> Bool in
                            return order.id ?? 0 == model.id ?? 0 || !(model.totalPaid ?? 0 >= model.total ?? 0 && model.total ?? 0 > 0)
                        })
                        if index == nil{
                            isSelectAll = false
                            break
                        }
                    }
                }
            }
        }else if selectedOrderType?.id ?? 0 == 3{
            for order in arrOngoingDeliveryOrders{
                let index = self.arrSelectedOrders.firstIndex(where: { (model) -> Bool in
                    return order.id ?? 0 == model.id ?? 0 || !(model.totalPaid ?? 0 >= model.total ?? 0 && model.total ?? 0 > 0)
                })
                if index == nil{
                    isSelectAll = false
                    break
                }
            }
        }else if selectedOrderType?.id ?? 0 == 5{
            for order in arrOngoingWaitingOrders{
                let index = self.arrSelectedOrders.firstIndex(where: { (model) -> Bool in
                    return order.id ?? 0 == model.id ?? 0 || !(model.totalPaid ?? 0 >= model.total ?? 0 && model.total ?? 0 > 0)
                })
                if index == nil{
                    isSelectAll = false
                    break
                }
            }
        }else if selectedOrderType?.id ?? 0 == 2{
            for order in arrOngoingCollectionOrders{
                let index = self.arrSelectedOrders.firstIndex(where: { (model) -> Bool in
                    return order.id ?? 0 == model.id ?? 0 || !(model.totalPaid ?? 0 >= model.total ?? 0 && model.total ?? 0 > 0)
                })
                if index == nil{
                    isSelectAll = false
                    break
                }
            }
        }
        return isSelectAll
    }
    
    func calculateFloorWidth(){
        let width = self.collectionFloor.superview!.frame.width
        var floorWidth:CGFloat = 0
        for floor in arrFloors{
            floorWidth += ((floor.name ?? "").getStringWidth(font: AppConstants.GlobalFontConstants.kBoldFont(size: 16)) + 35)
        }
        if floorWidth > width{
            self.constFloorWidth.constant = width
            self.collectionFloor.isScrollEnabled = true
        }else{
            self.collectionFloor.isScrollEnabled = false
            self.constFloorWidth.constant = floorWidth
        }
    }
    
    func setOrderTypeView(){
        lblShowAllLine.backgroundColor = AppConstants.Colors.kAppLightGrayColor
        lblShowAll.textColor = AppConstants.Colors.kAppLightGrayColor
        lblAllActiveOrder.textColor = AppConstants.Colors.kAppLightGrayColor
        
        lblCollectionLine.backgroundColor = AppConstants.Colors.kAppLightGrayColor
        lblCollection.textColor = AppConstants.Colors.kAppLightGrayColor
        lblCollectionActiveOrder.textColor = AppConstants.Colors.kAppLightGrayColor
        
        lblDeliveryLine.backgroundColor = AppConstants.Colors.kAppLightGrayColor
        lblDelivery.textColor = AppConstants.Colors.kAppLightGrayColor
        lblDeliveryActiveOrder.textColor = AppConstants.Colors.kAppLightGrayColor
        
        lblWaitingLine.backgroundColor = AppConstants.Colors.kAppLightGrayColor
        lblWaiting.textColor = AppConstants.Colors.kAppLightGrayColor
        lblWaitingActiveOrder.textColor = AppConstants.Colors.kAppLightGrayColor
        
        lblOnlineLine.backgroundColor = AppConstants.Colors.kAppLightGrayColor
        lblOnlineOrders.textColor = AppConstants.Colors.kAppLightGrayColor
        lblOnlineActiveOrder.textColor = AppConstants.Colors.kAppLightGrayColor
        
        if self.selectedOrderType?.id ?? 0 == 0{
            lblShowAllLine.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
            lblShowAll.textColor = AppConstants.Colors.kAppThemeTextColor
            lblAllActiveOrder.textColor = AppConstants.Colors.kAppThemeTextColor
        }else{
            if selectedOrderType?.id ?? 0 == 2{
                lblCollectionLine.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
                lblCollection.textColor = AppConstants.Colors.kAppThemeTextColor
                lblCollectionActiveOrder.textColor = AppConstants.Colors.kAppThemeTextColor
            }else if selectedOrderType?.id ?? 0 == 3{
                lblDeliveryLine.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
                lblDelivery.textColor = AppConstants.Colors.kAppThemeTextColor
                lblDeliveryActiveOrder.textColor = AppConstants.Colors.kAppThemeTextColor
            }else if selectedOrderType?.id ?? 0 == 5{
                lblWaitingLine.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
                lblWaiting.textColor = AppConstants.Colors.kAppThemeTextColor
                lblWaitingActiveOrder.textColor = AppConstants.Colors.kAppThemeTextColor
            }else if selectedOrderType?.id ?? 0 == 6{
                lblOnlineLine.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
                lblOnlineOrders.textColor = AppConstants.Colors.kAppThemeTextColor
                lblOnlineActiveOrder.textColor = AppConstants.Colors.kAppThemeTextColor
            }
        }
    }
    
    @objc func reloadOrderData(showLoader: Bool = true){
        if !self.lblShowTable.superview!.isHidden{
//            if AppConstants.DataSyncMode == "Auto" && Reachabilities.shared.isConnectedToNetwork(){
//                self.FetchOrdersList()
//            }else{
                self.checkForOrderType()
//            }
            if AppCommonMethods.fetchSiteSettingValue(key: "is_weborder") ?? "" == "true" && AppConstants.userData?.permissions?.weborder?.actions?.list ?? 0 == 1{
                self.GetOnlineOrders(showLoader: showLoader)
            }
        }
        self.collectionTable.reloadData()
    }
    
    func sortOrderList(){
        self.arrCompletedOrder = self.arrCompletedOrder.sorted(by: { (model1, model2) -> Bool in
            var cDate1 = ""
            var cDate2 = ""
            if (model1.orderType ?? "").lowercased() == "dine in"{
                cDate1 = ((model1.created ?? "").components(separatedBy: ".").first ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd'T'HH:mm:ss", toFormat: "yyyy-MM-dd hh:mm a") ?? ""
            }else{
                cDate1 = (model1.deliveryDate ?? "").components(separatedBy: "T").first ?? ""
                cDate1 = "\(cDate1) \(model1.deliveryTime ?? "")"
            }
            if (model2.orderType ?? "").lowercased() == "dine in"{
                cDate2 = ((model2.created ?? "").components(separatedBy: ".").first ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd'T'HH:mm:ss", toFormat: "yyyy-MM-dd hh:mm a") ?? ""
            }else{
                cDate2 = (model2.deliveryDate ?? "").components(separatedBy: "T").first ?? ""
                cDate2 = "\(cDate2) \(model2.deliveryTime ?? "")"
            }
            if let date1 = cDate1.getDateFromString(format: "yyyy-MM-dd hh:mm a", locale: nil), let date2 = cDate2.getDateFromString(format: "yyyy-MM-dd hh:mm a", locale: nil){
                return date1 > date2
            }
            return true
        })
        self.arrCurrentOrder = self.arrCurrentOrder.sorted(by: { (model1, model2) -> Bool in
            var cDate1 = ""
            var cDate2 = ""
            if (model1.orderType ?? "").lowercased() == "dine in"{
                cDate1 = ((model1.created ?? "").components(separatedBy: ".").first ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd'T'HH:mm:ss", toFormat: "yyyy-MM-dd hh:mm a") ?? ""
            }else{
                cDate1 = (model1.deliveryDate ?? "").components(separatedBy: "T").first ?? ""
                cDate1 = "\(cDate1) \(model1.deliveryTime ?? "")"
            }
            if (model2.orderType ?? "").lowercased() == "dine in"{
                cDate2 = ((model2.created ?? "").components(separatedBy: ".").first ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd'T'HH:mm:ss", toFormat: "yyyy-MM-dd hh:mm a") ?? ""
            }else{
                cDate2 = (model2.deliveryDate ?? "").components(separatedBy: "T").first ?? ""
                cDate2 = "\(cDate2) \(model2.deliveryTime ?? "")"
            }
            if let date1 = cDate1.getDateFromString(format: "yyyy-MM-dd hh:mm a", locale: nil), let date2 = cDate2.getDateFromString(format: "yyyy-MM-dd hh:mm a", locale: nil){
                return date1 > date2
            }
            return true
        })
        self.arrNewOrder = self.arrNewOrder.sorted(by: { (model1, model2) -> Bool in
            var cDate1 = ""
            var cDate2 = ""
            if (model1.orderType ?? "").lowercased() == "dine in"{
                cDate1 = ((model1.created ?? "").components(separatedBy: ".").first ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd'T'HH:mm:ss", toFormat: "yyyy-MM-dd hh:mm a") ?? ""
            }else{
                cDate1 = (model1.deliveryDate ?? "").components(separatedBy: "T").first ?? ""
                cDate1 = "\(cDate1) \(model1.deliveryTime ?? "")"
            }
            if (model2.orderType ?? "").lowercased() == "dine in"{
                cDate2 = ((model2.created ?? "").components(separatedBy: ".").first ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd'T'HH:mm:ss", toFormat: "yyyy-MM-dd hh:mm a") ?? ""
            }else{
                cDate2 = (model2.deliveryDate ?? "").components(separatedBy: "T").first ?? ""
                cDate2 = "\(cDate2) \(model2.deliveryTime ?? "")"
            }
            if let date1 = cDate1.getDateFromString(format: "yyyy-MM-dd hh:mm a", locale: nil), let date2 = cDate2.getDateFromString(format: "yyyy-MM-dd hh:mm a", locale: nil){
                return date1 > date2
            }
            return true
        })
        if homeTheme == "theme4"{
            self.arrNewOrder.append(contentsOf: self.arrCurrentOrder)
        }
    }
    
    //MARK: Webservice Methods
    func FetchTableList(floorData:FloorModel){
        let dictParam = [String:String]()
        WebServiceManager().requestAPI(params: dictParam, urlString: "\(AppConstants.APIURL.kFloorList)/\(floorData.id ?? 0)", method: "GET") { (message, result) in
            DispatchQueue.main.async {
                if let response = result as? NSDictionary{
                    let jsonDecoder = JSONDecoder()
                    if let arr = response["tables"] as? [NSDictionary], let data = AppCommonMethods.convertToJson(object: arr), let aData = try? jsonDecoder.decode([TableModel].self, from: data){
                        SQLiteManage.insertTable(arrData: aData, floorId: floorData.id)
                    }
                }
                self.collectionTable.reloadData()
            }
        }
    }
    
    func FetchTableDetail(tableId:Int){
        var dictParam = [String:String]()
        dictParam["nopaginate"] = "1"
        WebServiceManager().requestAPI(params: dictParam, urlString: "\(AppConstants.APIURL.kTables)\(tableId)", method: "GET") { (message, result) in
            DispatchQueue.main.async {
                let jsonDecoder = JSONDecoder()
                if let response = result as? NSDictionary, let data = AppCommonMethods.convertToJson(object: response), let aData = try? jsonDecoder.decode(TableModel.self, from: data){
                    SQLiteManage.updateTable(model: aData)
                }
                self.collectionTable.reloadData()
            }
        }
    }
    
    func FetchOrderDetail(table:TableModel, isFromAction:Bool = true){
        if table.lastOrderId ?? 0 == 0{
            AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_NO_ORDER)
            return
        }
        let dictParam = [String:String]()
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam, urlString: "\(AppConstants.APIURL.kCreateOrder)/\(table.lastOrderId ?? 0)", method: "GET") { (message, result) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                if let response = result as? NSDictionary{
                    let jsonDecoder = JSONDecoder()
                    if let data = AppCommonMethods.convertToJson(object: response), let aData = try? jsonDecoder.decode(OrderModel.self, from: data){
                        SQLiteManage.SaveOrderIntoDatabase(order: aData, updated: 0)
                        if let model = SQLiteManage.fetchOrderDataById(orderId: table.lastOrderId ?? 0){
                            if isFromAction{
                                if (table.tableStatus?.status ?? "").lowercased() == "taking order"{
                                    if AppCommonMethods.fetchSiteSettingValue(key: "cancel_order_password_enable") ?? "" == "true"{
                                        var setting = AlertSetting()
                                        setting.alertTitle = AppConstants.GlobalAlert.ALERT_ENTER_PASSWORD
                                        setting.alertMessage = AppConstants.GlobalAlert.ALERT_ENTER_PASSWORD_CANCELORDER
                                        setting.textPlcaeholder = "password"
                                        setting.type = .kEnterUserPassword
                                        setting.textType = .default
                                        if let VC = AlertViewController.showPopup(parentVC: self.parentVC, setting: setting){
                                            VC.delegate = self
                                        }
                                    }else{
                                        var setting = AlertSetting()
                                        setting.alertMessage = AppConstants.GlobalAlert.ALERT_CANCEL_ORDER
                                        setting.alertTitle = AppConstants.GlobalAlert.ALERT_CANCEL_ORDER_TITLE
                                        setting.type = .kRejectOrder
                                        if let VC = AlertViewController.showPopup(parentVC: self.parentVC, setting: setting){
                                            VC.delegate = self
                                        }
                                    }
                                    self.selectedTable = table
                                    self.selectedOrder = model
                                }else{
                                    self.performOrderAction(table: table, order: model)
                                }
                            }else{
                                if let VC = CreateOrderVC.instance(){
                                    VC.selectedTable = table
                                    let arr = AppConstants.arrOrderTypes.filter({ model in
                                        return model.id ?? 0 == 1
                                    })
                                    if arr.count > 0{
                                        VC.orderType = arr[0]
                                    }
                                    VC.orderId = table.lastOrderId ?? 0
                                    self.navigationController?.pushViewController(VC, animated: true)
                                }
                            }
                        }
                        return
                    }
                }
                AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_NO_ORDER)
            }
        }
    }
    
    func addNewOnlineOrder(order:WebOrderModel, isNewOrder:Bool){
        if isNewOrder{
            self.arrNewOrder.append(order)
            if self.arrNewOrder.count > 0{
                self.lblOnlineActiveOrder.text = "\(self.arrNewOrder.count) Active Orders"
            }else{
                self.lblOnlineActiveOrder.text = "No Active Orders"
            }
        }else{
            self.arrCurrentOrder.append(order)
        }
        self.sortOrderList()
        self.collectionOnlineOrders.reloadData()
    }
    
    func GetOnlineOrders(showLoader:Bool = true){
        if showLoader{
            AppCommonMethods.startProgressBar()
        }
        var dictParam = [String:String]()
        if let id = AppConstants.webResId{
            dictParam["restaurant_id"] = id
        }
        WebServiceManager().requestAPI(params: dictParam,  urlString: "\(AppConstants.APIURL.kOnlineOrder)home", method: "GET",isRestaurantAPI: true) { (message, result) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                let jsonDecoder = JSONDecoder()
                if let response = result as? NSDictionary{
                    self.arrNewOrder.removeAll()
                    self.arrCurrentOrder.removeAll()
                    if let arrO = response["pending_orders"] as? [NSDictionary], let data = AppCommonMethods.convertToJson(object: arrO), let aData = try? jsonDecoder.decode([WebOrderModel].self, from: data){
                        self.arrNewOrder = aData
                    }
                    if let arrO = response["pending_dinein_orders"] as? [NSDictionary], let data = AppCommonMethods.convertToJson(object: arrO), let aData = try? jsonDecoder.decode([WebOrderModel].self, from: data){
                        aData.forEach { model in
                            model.orderType = "dine in"
                        }
                        self.arrNewOrder.append(contentsOf: aData)
                    }
                    if let arrO = response["accepted_orders"] as? [NSDictionary], let data = AppCommonMethods.convertToJson(object: arrO), let aData = try? jsonDecoder.decode([WebOrderModel].self, from: data){
                        self.arrCurrentOrder = aData
                    }
                    if let arrO = response["accepted_dinein_orders"] as? [NSDictionary], let data = AppCommonMethods.convertToJson(object: arrO), let aData = try? jsonDecoder.decode([WebOrderModel].self, from: data){
                        aData.forEach { model in
                            model.orderType = "dine in"
                        }
                        self.arrCurrentOrder.append(contentsOf: aData)
                    }
                    if let arrO = response["completed_orders"] as? [NSDictionary], let data = AppCommonMethods.convertToJson(object: arrO), let aData = try? jsonDecoder.decode([WebOrderModel].self, from: data){
                        self.arrCompletedOrder = aData
                    }
                    if let arrO = response["completed_dinein_orders"] as? [NSDictionary], let data = AppCommonMethods.convertToJson(object: arrO), let aData = try? jsonDecoder.decode([WebOrderModel].self, from: data){
                        aData.forEach { model in
                            model.orderType = "dine in"
                        }
                        self.arrCompletedOrder.append(contentsOf: aData)
                    }
                    if self.arrNewOrder.count > 0{
                        self.lblOnlineActiveOrder.text = "\(self.arrNewOrder.count) Active Orders"
                    }else{
                        self.lblOnlineActiveOrder.text = "No Active Orders"
                    }
                    self.sortOrderList()
                    self.collectionOnlineOrders.reloadData()
                }else{
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: message, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        
                    }
                }
            }
        }
    }
    
    func CallSetOrderStatusAPI(status:String){
        var dictParam = [String:Any]()
        let orderType = arrCurrentOrder[selectedOrderRow!].orderType ?? ""
        let orderId = arrCurrentOrder[selectedOrderRow!].id ?? 0
        var strURL = "\(AppConstants.APIURL.kOnlineOrder)\(orderId)/change-status"
        if orderType.lowercased() == "dine in"{
            strURL = "\(AppConstants.APIURL.kOnlineDineinOrder)\(orderId)/change-status"
        }
        dictParam["status"] = status
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam,  urlString: strURL, method: "POST",isRestaurantAPI: true) { (message, result) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                let jsonDecoder = JSONDecoder()
                if let arrO = result as? NSDictionary, let data = AppCommonMethods.convertToJson(object: arrO), let model = try? jsonDecoder.decode(WebOrderModel.self, from: data){
                    var setting = BottomAlertSettings()
                    setting.strMessage = AppConstants.GlobalAlert.ORDER_COMPLETED
                    setting.isClickable = true
                    setting.id = orderId
                    setting.orderType = orderType
                    setting.type = .kOrder
                    if status == "Delivered"{
                        setting.bgColor = AppConstants.Colors.kAppDarkGreenColor
                        setting.strMessage = AppConstants.GlobalAlert.ORDER_COMPLETED
                    }
                    AppValidation().showBottomAlertView(settings: setting)
                    if self.selectedOrderSection! == 0{
                        self.arrNewOrder.remove(at: self.selectedOrderRow!)
                    }else{
                        self.arrCurrentOrder.remove(at: self.selectedOrderRow!)
                    }
                    if orderType.lowercased() == "dine in"{
                        model.orderType = "dine in"
                        let createDate = (model.created ?? "").components(separatedBy: "T").first ?? ""
                        if let date = createDate.getDateFromString(format: "yyyy-MM-dd", locale: nil){
                            if let currentDate = Date().getDateInString(format: "yyyy-MM-dd").getDateFromString(format: "yyyy-MM-dd", locale: nil){
                                if date == currentDate{
                                    if (model.status ?? "").lowercased() == "accepted"{
                                        self.arrCurrentOrder.append(model)
                                    }else if (model.status ?? "").lowercased() == "delivered"{
                                        self.arrCompletedOrder.append(model)
                                    }
                                }
                            }
                        }
                    }else{
                        let cDate = (model.deliveryDate ?? "").components(separatedBy: "T").first ?? ""
                        if let date = cDate.getDateFromString(format: "yyyy-MM-dd", locale: nil){
                            let currentDate = Date().getDateInString(format: "yyyy-MM-dd").getDateFromString(format: "yyyy-MM-dd", locale: nil)!
                            if date >= currentDate{
                                if (model.status ?? "").lowercased() == "accepted"{
                                    self.arrCurrentOrder.append(model)
                                }else if (model.status ?? "").lowercased() == "delivered"{
                                    self.arrCompletedOrder.append(model)
                                }
                            }
                        }
                    }
                    BadgeManager.shared?.stopLastAPICall()
                    self.sortOrderList()
                    self.collectionOnlineOrders.reloadData()
                }else{
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: message, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        
                    }
                }
            }
        }
    }
    
    //MARK: Database Methods
    @objc func checkForOrderType(){
        self.arrOrderTypeIds = [0]
        let isWaitingAvailable = AppCommonMethods.fetchSiteSettingValue(key: "is_waiting") ?? "" == "true" && AppConstants.userData?.permissions?.waiting?.actions?.list ?? 0 == 1
        let isCollectionAvailable = AppCommonMethods.fetchSiteSettingValue(key: "is_collection") ?? "" == "true" && AppConstants.userData?.permissions?.collection?.actions?.list ?? 0 == 1
        let isDeliveryAvailable = AppCommonMethods.fetchSiteSettingValue(key: "is_delivery") ?? "" == "true" && AppConstants.userData?.permissions?.delivery?.actions?.list ?? 0 == 1
        let isOnlineAvailable = AppCommonMethods.fetchSiteSettingValue(key: "is_weborder") ?? "" == "true" && AppConstants.userData?.permissions?.weborder?.actions?.list ?? 0 == 1
        orderShownCount = 0
        if isWaitingAvailable{
            orderAvailableCount += 1
            self.arrOrderTypeIds.append(5)
            self.lblWaiting.superview?.isHidden = false
            self.collectionWaitingOrders.isHidden = false
        }else{
            self.lblWaiting.superview?.isHidden = true
            self.collectionWaitingOrders.isHidden = true
        }
        if isCollectionAvailable{
            orderAvailableCount += 1
            self.arrOrderTypeIds.append(2)
            self.lblCollection.superview?.isHidden = false
            self.collectionCollectionOrders.isHidden = false
        }else{
            self.lblCollection.superview?.isHidden = true
            self.collectionCollectionOrders.isHidden = true
        }
        if isDeliveryAvailable{
            orderAvailableCount += 1
            self.arrOrderTypeIds.append(3)
            self.lblDelivery.superview?.isHidden = false
            self.collectionDeliveryOrders.isHidden = false
        }else{
            self.lblDelivery.superview?.isHidden = true
            self.collectionDeliveryOrders.isHidden = true
        }
        if isOnlineAvailable{
            orderAvailableCount += 1
            self.arrOrderTypeIds.append(6)
            self.lblOnlineOrders.superview?.isHidden = false
            self.collectionOnlineOrders.isHidden = false
        }else{
            self.lblOnlineOrders.superview?.isHidden = true
            self.collectionOnlineOrders.isHidden = true
        }
        var totalCount = 0
        self.arrOrderSection.removeAll()
        if isWaitingAvailable{
            if AppCommonMethods.fetchSiteSettingValue(key: "show_completed_orders") ?? "" == "true"{
                self.arrOngoingWaitingOrders = SQLiteManage.fetchAllOrdersData(orderType: 5)
            }else{
                self.arrOngoingWaitingOrders = SQLiteManage.fetchOngoingOrdersData(orderType: 5)
            }
            self.waitingCount = self.arrOngoingWaitingOrders.count
            self.dictOrders["Waiting"] = self.arrOngoingWaitingOrders
            if self.waitingCount > 0{
                orderShownCount += 1
                self.arrOrderSection.append("Waiting")
            }
            totalCount = self.waitingCount
        }
        if isCollectionAvailable{
            if AppCommonMethods.fetchSiteSettingValue(key: "show_completed_orders") ?? "" == "true"{
                self.arrOngoingCollectionOrders = SQLiteManage.fetchAllOrdersData(orderType: 2)
            }else{
                self.arrOngoingCollectionOrders = SQLiteManage.fetchOngoingOrdersData(orderType: 2)
            }
            self.collectionCount = self.arrOngoingCollectionOrders.count
            self.dictOrders["Collection"] = self.arrOngoingCollectionOrders
            if self.collectionCount > 0{
                orderShownCount += 1
                self.arrOrderSection.append("Collection")
            }
            totalCount += self.collectionCount
        }
        if isDeliveryAvailable{
            if AppCommonMethods.fetchSiteSettingValue(key: "show_completed_orders") ?? "" == "true"{
                self.arrOngoingDeliveryOrders = SQLiteManage.fetchAllOrdersData(orderType: 3)
            }else{
                self.arrOngoingDeliveryOrders = SQLiteManage.fetchOngoingOrdersData(orderType: 3)
            }
            self.deliveryCount = self.arrOngoingDeliveryOrders.count
            self.dictOrders["Delivery"] = self.arrOngoingDeliveryOrders
            if self.deliveryCount > 0{
                orderShownCount += 1
                self.arrOrderSection.append("Delivery")
            }
            totalCount += self.deliveryCount
        }
        if isOnlineAvailable && self.arrNewOrder.count > 0{
            orderShownCount += 1
        }
        if self.waitingCount > 0{
            self.lblWaitingActiveOrder.text = "\(self.waitingCount) Active Orders"
        }else{
            self.lblWaitingActiveOrder.text = "No Active Orders"
        }
        if self.collectionCount > 0{
            self.lblCollectionActiveOrder.text = "\(self.collectionCount) Active Orders"
        }else{
            self.lblCollectionActiveOrder.text = "No Active Orders"
        }
        if self.deliveryCount > 0{
            self.lblDeliveryActiveOrder.text = "\(self.deliveryCount) Active Orders"
        }else{
            self.lblDeliveryActiveOrder.text = "No Active Orders"
        }
        if totalCount > 0{
            self.lblAllActiveOrder.text = "\(totalCount) Active Orders"
        }else{
            self.lblAllActiveOrder.text = "No Active Orders"
        }
        
        if homeTheme == "theme4"{
            self.viewForTheme4.isHidden = false
            btnOrderHistoryTheme4.isHidden = false
            if arrOngoingWaitingOrders.count > 0{
                self.collectionWaitingOrdersTheme4.isHidden = false
                self.collectionWaitingOrdersTheme4.reloadData()
            }else{
                self.collectionWaitingOrdersTheme4.isHidden = true
            }
            if arrOngoingDeliveryOrders.count > 0{
                self.collectionDeliveryOrdersTheme4.isHidden = false
                self.collectionDeliveryOrdersTheme4.reloadData()
            }else{
                self.collectionDeliveryOrdersTheme4.isHidden = true
            }
            if arrOngoingCollectionOrders.count > 0{
                self.collectionCollectionOrdersTheme4.isHidden = false
                self.collectionCollectionOrdersTheme4.reloadData()
            }else{
                self.collectionCollectionOrdersTheme4.isHidden = true
            }
        }else{
            btnOrderHistoryTheme4.isHidden = true
            self.viewForTheme4.isHidden = true
            self.collectionAllOrders.reloadData()
            self.collectionCollectionOrders.reloadData()
            self.collectionWaitingOrders.reloadData()
            self.collectionDeliveryOrders.reloadData()
        }
    }
    
    @objc func FetchFloorList(){
        self.arrFloors = CoreDataHelper.shared.fetchFloorData()
        var arrFloorName = [String]()
        for model in self.arrFloors{
            arrFloorName.append(model.name ?? "")
        }
//        if self.arrFloors.count > selectedFloorIndex{
//            if Reachabilities.shared.isConnectedToNetwork(){
//                FetchTableList(floorData: arrFloors[selectedFloorIndex])
//            }
//        }else if self.arrFloors.count > 0{
//            selectedFloorIndex = 0
//            if Reachabilities.shared.isConnectedToNetwork(){
//                FetchTableList(floorData: arrFloors[0])
//            }
//        }
        DispatchQueue.main.async {
            self.collectionTable.reloadData()
            self.collectionFloor.reloadData()
            self.calculateFloorWidth()
        }
    }
    
    func FetchFloorListFromDB(){
        self.arrFloors = CoreDataHelper.shared.fetchFloorData()
        var arrFloorName = [String]()
        for model in self.arrFloors{
            arrFloorName.append(model.name ?? "")
        }
        self.collectionTable.reloadData()
        self.collectionFloor.reloadData()
        self.calculateFloorWidth()
    }
    
    @objc func fetchCount(){
        arrHomeData = [.init(title: "Active Orders", image: "ic_order_print", type: SideMenuCellType.kActiveOrder),.init(title: "Waiting", image: "ic_order_print", type: SideMenuCellType.kWaiting),.init(title: "Collection", image: "ic_order_print", type: SideMenuCellType.kCollection),.init(title: "Delivery", image: "ic_order_print", type: SideMenuCellType.kDelivery),.init(title: "Online Orders", image: "ic_tiffintom", type: SideMenuCellType.kOnlineOrders),.init(title: "Tables", image: "ic_table", type: SideMenuCellType.kTables),.init(title: "Order History", image: "ic_order_print", type: SideMenuCellType.kOrderHistory),.init(title: "Reservations", image: "ic_table", type: SideMenuCellType.kReservation),.init(title: "Messages", image: "ic_message", type: SideMenuCellType.kMessages),.init(title: "Payments", image: "ic_payment", type: SideMenuCellType.kPayments),.init(title: "Cash Drawer", image: "ic_cash", type: SideMenuCellType.kCashDrawer),.init(title: "Settings", image: "settings", type: SideMenuCellType.kSettings),.init(title: "Vouchers", image: "voucher", type: SideMenuCellType.kVoucher),.init(title: "Table Status", image: "ic_table", type: SideMenuCellType.kTableStatues),.init(title: "Customers", image: "profile_placeholder", type: SideMenuCellType.kCustomers)]
        if AppCommonMethods.fetchSiteSettingValue(key: "is_dinein") ?? "" == "true" && AppConstants.userData?.permissions?.dinein?.actions?.list ?? 0 == 1{
            
        }else{
            arrHomeData.remove(at: 13)
        }
        if AppConstants.userData?.permissions?.vouchers?.actions?.list ?? 0 == 1{
            
        }else{
            arrHomeData.remove(at: 12)
        }
        if AppConstants.userData?.permissions?.cashdrawer?.actions?.list ?? 0 == 0{
            arrHomeData.remove(at: 10)
        }
        if AppCommonMethods.fetchSiteSettingValue(key: "is_weborder") ?? "" == "true" && AppConstants.userData?.permissions?.weborder?.actions?.list ?? 0 == 1{
            
        }else{
            arrHomeData.remove(at: 8)
        }
        if AppCommonMethods.fetchSiteSettingValue(key: "is_reservation") ?? "" == "true" && AppConstants.userData?.permissions?.reservation?.actions?.list ?? 0 == 1{
        }else{
            arrHomeData.remove(at: 7)
        }
        if AppCommonMethods.fetchSiteSettingValue(key: "is_dinein") ?? "" == "true" && AppConstants.userData?.permissions?.dinein?.actions?.list ?? 0 == 1{
        }else{
            arrHomeData.remove(at: 5)
        }
        if AppCommonMethods.fetchSiteSettingValue(key: "is_weborder") ?? "" == "true" && AppConstants.userData?.permissions?.weborder?.actions?.list ?? 0 == 1{
            
        }else{
            arrHomeData.remove(at: 4)
        }
        if AppCommonMethods.fetchSiteSettingValue(key: "is_delivery") ?? "" == "true" && AppConstants.userData?.permissions?.delivery?.actions?.list ?? 0 == 1{
            deliveryCount = SQLiteManage.fetchCountOfTable(whereString: "WHERE order_type_id = 3 AND isDelete = 0 AND (order_status_id = 1 OR order_status_id = 2 OR order_status_id = 12 OR order_status_id = 13 OR order_status_id = 14 OR order_status_id = 4 OR order_status_id = 7 OR order_status_id = 6) AND business_id = \(AppConstants.businessData?.id ?? 0) AND is_archived = 0", tableName: "Orders")
        }else{
            arrHomeData.remove(at: 3)
            deliveryCount = 0
        }
        if AppCommonMethods.fetchSiteSettingValue(key: "is_collection") ?? "" == "true" && AppConstants.userData?.permissions?.collection?.actions?.list ?? 0 == 1{
            collectionCount = SQLiteManage.fetchCountOfTable(whereString: "WHERE order_type_id = 2 AND isDelete = 0 AND (order_status_id = 1 OR order_status_id = 2 OR order_status_id = 12 OR order_status_id = 13 OR order_status_id = 14 OR order_status_id = 4 OR order_status_id = 7 OR order_status_id = 6) AND business_id = \(AppConstants.businessData?.id ?? 0) AND is_archived = 0", tableName: "Orders")
        }else{
            arrHomeData.remove(at: 2)
            collectionCount = 0
        }
        if AppCommonMethods.fetchSiteSettingValue(key: "is_waiting") ?? "" == "true" && AppConstants.userData?.permissions?.waiting?.actions?.list ?? 0 == 1{
            waitingCount = SQLiteManage.fetchCountOfTable(whereString: "WHERE order_type_id = 5 AND isDelete = 0 AND (order_status_id = 1 OR order_status_id = 2 OR order_status_id = 12 OR order_status_id = 13 OR order_status_id = 14 OR order_status_id = 4 OR order_status_id = 7 OR order_status_id = 6) AND business_id = \(AppConstants.businessData?.id ?? 0) AND is_archived = 0", tableName: "Orders")
            
        }else{
            arrHomeData.remove(at: 1)
            waitingCount = 0
        }
        totalCount = deliveryCount + waitingCount + collectionCount
        let columns = (AppConstants.ScreenSize.SCREEN_HEIGHT >= 1024) ? 16 : 9
        if self.arrHomeData.count > columns{
            if scrollOrders.currentPage == 1{
                self.btnPreviousPage.isHidden = true
            }else{
                self.btnPreviousPage.isHidden = false
            }
            if scrollOrders.currentPage == 2{
                self.btnNextPage.isHidden = true
            }else{
                self.btnNextPage.isHidden = false
            }
        }else{
            self.btnNextPage.isHidden = true
            self.btnPreviousPage.isHidden = true
        }
        collectionHome.reloadData()
    }
    
    func checkForOrderReset(){
        let time = AppCommonMethods.fetchSiteSettingValue(key: "business_evening_end_time") ?? ""
        let orderCount = SQLiteManage.fetchCountOfTable(whereString: "WHERE business_id = '\(AppConstants.businessData?.id ?? 0)'", tableName: "Orders")
        if !time.removeSpace.isEmpty && orderCount > 0{
            if let targetDate = calculateTargetDate(from: time, addingHours: 3){
                let todayKey = "hasOrderResetDone_" + Date().getDateInString(format: "dd-MM-yyyy")
                let hasOrderResetDone = UserDefaults.standard.bool(forKey: todayKey)
                if !hasOrderResetDone && Date() >= targetDate {
                    if AppCommonMethods.fetchSiteSettingValue(key: "order_reset_auto") ?? "" == "yes"{
                        self.CallResetAPI()
                    }else{
                        if let VC = OrderResetAlertVC.showPopup(parentVC: self.parentVC){
                            VC.orderReset = {
                                self.CallResetAPI()
                            }
                        }
                    }
                }
            }
        }
    }
    
    private func calculateTargetDate(from hhmm: String, addingHours hours: Int) -> Date? {
        let formatter = DateFormatter()
        formatter.dateFormat = "HH:mm"
        formatter.locale = Locale(identifier: "en_US_POSIX")
        
        guard let timeDate = formatter.date(from: hhmm) else { return nil }
        
        // extract hour & minute components
        let calendar = Calendar.current
        let comps = calendar.dateComponents([.hour, .minute], from: timeDate)
        
        // build a Date for *today* at those components
        var todayComps = calendar.dateComponents([.year, .month, .day], from: Date())
        todayComps.hour = comps.hour
        todayComps.minute = comps.minute
        
        guard let todayTime = calendar.date(from: todayComps) else { return nil }
        
        // add the offset
        return calendar.date(byAdding: .hour, value: hours, to: todayTime)
    }
    
    func CallResetAPI(){
        let dictParam = [String:Any]()
        let strURL = AppConstants.APIURL.kFactoryReset
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam, urlString: strURL, method: "DELETE") { (message, result) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
//                var aMSG = message
                if let response = result as? NSDictionary, let _ = response.getStringValue("message"){
                    //aMSG = "Factory reset done"
                    CoreDataHelper.shared.DeleteAllOrderData()
                    CoreDataHelper.shared.deleteDataFromDatabase(entity: "Reservations")
                    CoreDataHelper.shared.DeleteBlankCustomers()
                    let todayKey = "hasOrderResetDone_" + Date().getDateInString(format: "dd-MM-yyyy")
                    UserDefaults.standard.set(true, forKey: todayKey)
                    self.viewWillAppear(false)
                }
//                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: aMSG, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    
//                }
            }
        }
    }
}

//MARK:  UICollectionViewDataSource
extension HomeViewController:UICollectionViewDataSource, UICollectionViewDelegate, UICollectionViewDelegateFlowLayout{
    func scrollViewDidScroll(_ scrollView: UIScrollView) {
        if self.parentVC.sideMenuTap{
            return
        }
        if scrollView == scrollOrders{
            NSObject.cancelPreviousPerformRequests(withTarget: self, selector: #selector(setOrderSelectionView), object: nil)
            self.perform(#selector(setOrderSelectionView), with: nil, afterDelay: 0.1)
        }else if scrollView == collectionTable{
            NSObject.cancelPreviousPerformRequests(withTarget: self, selector: #selector(setTableSelectionView), object: nil)
            self.perform(#selector(setTableSelectionView), with: nil, afterDelay: 0.1)
        }else{
            DispatchQueue.main.async {
                let columns = (AppConstants.ScreenSize.SCREEN_HEIGHT >= 1024) ? 16 : 9
                if self.arrHomeData.count > columns{
                    self.lblPageCount.text = "Swipe for more - page \(scrollView.currentPage)/2"
                    if scrollView.currentPage == 1{
                        self.btnPreviousPage.isHidden = true
                    }else{
                        self.btnPreviousPage.isHidden = false
                    }
                    if scrollView.currentPage == 2{
                        self.btnNextPage.isHidden = true
                    }else{
                        self.btnNextPage.isHidden = false
                    }
                }else{
                    self.btnNextPage.isHidden = true
                    self.btnPreviousPage.isHidden = true
                    self.lblPageCount.text = ""
                }
            }
        }
    }
    
    @objc func setOrderSelectionView(){
        isServeSelected = false
        arrSelectedOrders.removeAll()
        self.selectedOrderTypeIndex = self.scrollOrders.currentPage-1
        if self.scrollOrders.currentPage-1 == 0{
            selectedOrderType = nil
        }else{
            selectedOrderType = AppConstants.arrOrderTypes.filter({ (model) -> Bool in
                return model.id ?? 0 == arrOrderTypeIds[self.scrollOrders.currentPage-1]
            }).first
        }
        btnOrderHistory.isHidden = false
        if selectedOrderType?.id ?? 0 == 6{
            if AppConstants.userData?.permissions?.onlineOrderHistory?.actions?.list ?? 0 == 0{
                btnOrderHistory.isHidden = true
            }
        }else{
            if AppConstants.userData?.permissions?.orderHistory?.actions?.list ?? 0 == 0{
                btnOrderHistory.isHidden = true
            }
        }
        DispatchQueue.main.async {
            self.setOrderTypeView()
        }
    }
    
    @objc func setTableSelectionView(){
//        if Reachabilities.shared.isConnectedToNetwork(){
//            FetchTableList(floorData: arrFloors[self.collectionTable.currentPage-1])
//        }
        selectedFloorIndex = self.collectionTable.currentPage-1
        let width = self.view.frame.width-40
        self.collectionTable.contentOffset = CGPoint.init(x: width*CGFloat(self.selectedFloorIndex), y: 0)
        self.collectionFloor.reloadData()
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
        if collectionView == collectionHome{
            if AppConstants.ScreenSize.SCREEN_HEIGHT >= 1024{
                return CGSize(width: (self.view.frame.width-40) / 4, height: (AppConstants.ScreenSize.SCREEN_HEIGHT - 155) / 4)
            }else{
                return CGSize(width: (self.view.frame.width-40) / 3, height: (AppConstants.ScreenSize.SCREEN_HEIGHT - 155) / 3)
            }
        }
        if collectionView == collectionTable{
            var height = (UIScreen.main.bounds.height - (20 + self.view.safeAreaInsets.top + self.view.safeAreaInsets.bottom))/2
            if self.lblShowTable.superview!.isHidden{
                height = UIScreen.main.bounds.height - (20 + self.view.safeAreaInsets.top + self.view.safeAreaInsets.bottom + 20)
            }
            return CGSize(width: self.view.frame.width-40, height: height - 65)
        }
        if collectionView == collectionFloor{
            let width = (arrFloors[indexPath.row].name ?? "").getStringWidth(font: AppConstants.GlobalFontConstants.kBoldFont(size: 16)) + 30
            return CGSize.init(width: width, height: 53)
        }
        if indexPath.row == 0{
            return CGSize.init(width: self.view.frame.width-40, height: 30)
        }
        if homeTheme == "theme4"{
            let width = self.view.frame.width-40
            return CGSize.init(width: width/4, height: 115)
        }else{
            if collectionView == collectionOnlineOrders{
                return CGSize.init(width: equalCellWidth(estimateWidth:300), height: 165)
            }
            if self.isServeSelected{
                return CGSize.init(width: equalCellWidth(estimateWidth: 275), height: homeTheme == "theme3" ? 145 : 175)
            }else{
                return CGSize.init(width: equalCellWidth(estimateWidth: 275), height: homeTheme == "theme3" ? 115 : 145)
            }
        }
    }
    
    func equalCellWidth(estimateWidth:CGFloat)->CGFloat{
        let width = self.view.frame.width-40
        let cellWidth = width/round(width/estimateWidth)
        return floor(cellWidth)
    }
    
    func numberOfSections(in collectionView: UICollectionView) -> Int {
        if collectionView == collectionAllOrders{
            return self.arrOrderSection.count
        }
        if collectionView == collectionOnlineOrders{
            return 3
        }
        return 1
    }
    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        if collectionView == collectionHome{
            return arrHomeData.count
        }
        if collectionView == collectionFloor || collectionView == collectionTable{
            return arrFloors.count
        }
        if collectionView == collectionAllOrders{
            if let arr = self.dictOrders[self.arrOrderSection[section]] as? [OrderModel]{
                return arr.count+1
            }
            return 0
        }
        if collectionView == collectionOnlineOrders || collectionView == collectionOnlineOrdersTheme4{
            switch section {
            case 0:
                return (self.arrNewOrder.count == 0) ? 0 : self.arrNewOrder.count+1
            case 1:
                return (self.arrCurrentOrder.count == 0) ? 0 : self.arrCurrentOrder.count+1
            case 2:
                return (self.arrCompletedOrder.count == 0) ? 0 : self.arrCompletedOrder.count+1
            default:
                return 0
            }
        }
        if collectionView == collectionOnlineOrdersTheme4{
            return self.arrNewOrder.count
        }
        var count = 0
        if collectionView == collectionWaitingOrders || collectionView == collectionWaitingOrdersTheme4{
            count = self.arrOngoingWaitingOrders.count
        }else if  collectionView == collectionCollectionOrders || collectionView == collectionCollectionOrdersTheme4{
            count = self.arrOngoingCollectionOrders.count
        }else if  collectionView == collectionDeliveryOrders || collectionView == collectionDeliveryOrdersTheme4{
            count = self.arrOngoingDeliveryOrders.count
        }
        return (count == 0) ? 0 : count+1
    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        if collectionView == collectionFloor{
            let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "FloorViewCell", for: indexPath) as! FloorViewCell
            let model = arrFloors[indexPath.row]
            cell.lblFloorName.text = model.name ?? ""
            cell.lblFloorName.textColor = AppConstants.Colors.kAppLightGrayColor
            cell.lblFloorLine.backgroundColor = AppConstants.Colors.kAppLightGrayColor
            if model.id ?? 0 == arrFloors[selectedFloorIndex].id ?? 0{
                cell.lblFloorName.textColor = AppConstants.Colors.kAppThemeTextColor
                cell.lblFloorLine.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
            }
            return cell
        }else if collectionView == collectionTable{
            let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "TableListCell", for: indexPath) as! TableListCell
            cell.parentVC = self
            cell.arrTables = SQLiteManage.fetchTableData(floorId: arrFloors[indexPath.row].id ?? 0)
            arrFloors[indexPath.row].tableData = cell.arrTables
            cell.collectionTable.reloadData()
            return cell
        }else if collectionView == collectionHome{
            let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "HomeViewCell", for: indexPath) as! HomeViewCell
            let data = arrHomeData[indexPath.row]
            cell.lblTitle.text = data.title
            cell.lblDescription.text = ""
            cell.lblCount.isHidden = true
            switch data.type {
            case .kActiveOrder:
                if totalCount > 0{
                    cell.lblDescription.text = "\(totalCount) Active Orders"
                }
            case .kTables:
                let count = SQLiteManage.fetchCountOfTable(whereString: "WHERE table_status_id != 1", tableName: "Tables")
                if count > 0{
                    cell.lblDescription.text = "\(count) Active Orders"
                }
            case .kCollection:
                if collectionCount > 0{
                    cell.lblDescription.text = "\(collectionCount) Active Orders"
                }
            case .kWaiting:
                if waitingCount > 0{
                    cell.lblDescription.text = "\(waitingCount) Active Orders"
                }
            case .kDelivery:
                if deliveryCount > 0{
                    cell.lblDescription.text = "\(deliveryCount) Active Orders"
                }
            case .kReservation:
                let count = AppConstants.reservationCount + (CoreDataHelper.shared.numberOfRowOfEntity(name: "Reservations", predict: NSPredicate.init(format: "reservation_date_time >= %d AND reservation_status_id == 1",Int(Date().timeIntervalSince1970))) ?? 0)
                if count > 0{
                    cell.lblDescription.text = "New Reservation"
                    cell.lblCount.isHidden = false
                    cell.lblCount.text = "\(count)"
                }
            case .kOnlineOrders:
                if AppConstants.orderCount > 0{
                    cell.lblDescription.text = "New Order"
                    cell.lblCount.isHidden = false
                    cell.lblCount.text = "\(AppConstants.orderCount)"
                }
            case .kMessages:
                if AppConstants.chatCount > 0{
                    cell.lblDescription.text = "New Message"
                    cell.lblCount.isHidden = false
                    cell.lblCount.text = "\(AppConstants.chatCount)"
                }
            default:
                break
            }
            return cell
        }
        if indexPath.row == 0{
            let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "ProductHeaderCollectionCell", for: indexPath) as! ProductHeaderCollectionCell
            if collectionView != collectionOnlineOrders{
                cell.btnSelect?.isHidden = true
                cell.viewForArchived?.isHidden = true
                if AppCommonMethods.fetchSiteSettingValue(key: "order_complete_mode") ?? "" != "auto"{
                    if indexPath.section == 0{
                        if isServeSelected{
                            cell.viewForArchived?.isHidden = false
                            if self.checkForSelectAll(){
                                cell.viewForSelctAll.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
                                cell.viewForSelctAll.borderColor = AppConstants.Colors.kAppThemeAquaColor
                                cell.imgSelect.image = UIImage.init(named: "ic_selected_green")?.sd_tintedImage(with: .white)
                            }else{
                                cell.viewForSelctAll.borderColor = AppConstants.Colors.kAppThemeTextColor
                                cell.viewForSelctAll.backgroundColor = .white
                                cell.imgSelect.image = nil
                            }
                        }else{
                            cell.btnSelect?.isHidden = false
                        }
                    }
                }
            }
            if collectionView == collectionAllOrders{
                cell.lblTitle.text = "\(self.arrOrderSection[indexPath.section]) Orders (\((self.dictOrders[self.arrOrderSection[indexPath.section]] as! [OrderModel]).count))"
            }else{
                switch indexPath.section {
                case 0:
                    var count = 0
                    var orderType = ""
                    if collectionView == collectionDeliveryOrders || collectionView == collectionDeliveryOrdersTheme4{
                        count = self.arrOngoingDeliveryOrders.count
                        orderType = "Delivery"
                    }else if collectionView == collectionCollectionOrders || collectionView == collectionCollectionOrdersTheme4{
                        count = self.arrOngoingCollectionOrders.count
                        orderType = "Collection"
                    }else if collectionView == collectionWaitingOrders || collectionView == collectionWaitingOrdersTheme4{
                        count = self.arrOngoingWaitingOrders.count
                        orderType = "Waiting"
                    }else if collectionView == collectionOnlineOrdersTheme4{
                        count = self.arrNewOrder.count
                        orderType = "Online"
                    }
                    if collectionView == collectionOnlineOrders{
                        cell.lblTitle.text = "New order (\(self.arrNewOrder.count))"
                    }else{
                        if homeTheme == "theme4"{
                            cell.lblTitle.text = "\(orderType) Orders (\(count))"
                        }else{
                            cell.lblTitle.text = "Orders in progress (\(count))"
                        }
                    }
                case 1:
                    cell.lblTitle.text = "Order in progress (\(self.arrCurrentOrder.count))"
                case 2:
                    cell.lblTitle.text = "Completed orders (\(self.arrCompletedOrder.count))"
                default:
                    break
                }
            }
            return cell
        }
        if collectionView == collectionOnlineOrders || collectionView == collectionOnlineOrdersTheme4{
            var isDelayed = false
            var model:WebOrderModel!
            if indexPath.section == 0{
                model = self.arrNewOrder[indexPath.row-1]
            }else if indexPath.section == 1{
                model = self.arrCurrentOrder[indexPath.row-1]
                var cDate = ""
                if (model.orderType ?? "").lowercased() == "dine in"{
                    cDate = ((model.created ?? "").components(separatedBy: ".").first ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd'T'HH:mm:ss", toFormat: "yyyy-MM-dd") ?? ""
                }else{
                    cDate = (model.deliveryDate ?? "").components(separatedBy: "T").first ?? ""
                }
                if let time = model.preparation, let preparation = "\(cDate) \(time)".getDateFromString(format: "yyyy-MM-dd hh:mm a"){
                    if preparation <= Date(){
                        isDelayed = true
                    }
                }
            }else{
                model = self.arrCompletedOrder[indexPath.row-1]
            }
            let cell = collectionView.dequeueReusableCell(withReuseIdentifier: isDelayed ? "DelayedOrderViewCell" : "OrderViewCell", for: indexPath) as! OrderViewCell
            cell.btnView.tag = indexPath.row-1
            cell.btnView.accessibilityIdentifier = "\(indexPath.section)"
            
            cell.lblUserName.text = "#\(model.orderNumber ?? "")\n\(model.customerName ?? "")"
            if model.paymentStatus ?? "" == "P"{
                cell.lblPaid.text = "Paid"
                cell.lblPaid.textColor = AppConstants.Colors.kAppMediumGreenColor
            }else{
                cell.lblPaid.text = "Unpaid"
                cell.lblPaid.textColor = AppConstants.Colors.kAppThemeRedColor
            }
            cell.lblPaid.transform = CGAffineTransform(rotationAngle: CGFloat.pi / 2)
            cell.lblMainStatus.text = model.displayOrderType
            var strStatus = "Tap to view"
            cell.btnView.isHidden = false
            if !isDelayed{
                cell.lblStatus.superview?.isHidden = true
                cell.viewForBG.backgroundColor = AppConstants.Colors.kAppThemeBGColor
                cell.lblMainStatus.textColor = AppConstants.Colors.kAppThemeTextColor
                cell.lblUserName.textColor = AppConstants.Colors.kAppThemeTextColor
            }
            if model.status ?? "" == "Pending"{
                if (model.orderType ?? "").lowercased() == "delivery"{
                    cell.viewForBG.backgroundColor = AppConstants.Colors.kAppDarkGreenColor
                }else if (model.orderType ?? "").lowercased() == "pickup"{
                    cell.viewForBG.backgroundColor = AppConstants.Colors.kAppThemeBlueColor
                }else{
                    cell.viewForBG.backgroundColor = AppConstants.Colors.kAppThemeYellowColor
                }
                var cDate = ""
                if (model.orderType ?? "").lowercased() == "dine in"{
                    cDate = ((model.created ?? "").components(separatedBy: ".").first ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd'T'HH:mm:ss", toFormat: "yyyy-MM-dd") ?? ""
                }else{
                    cDate = (model.deliveryDate ?? "").components(separatedBy: "T").first ?? ""
                }
                if let date = cDate.getDateFromString(format: "yyyy-MM-dd", locale: nil){
                    let currentDate = Date().getDateInString(format: "yyyy-MM-dd").getDateFromString(format: "yyyy-MM-dd", locale: nil)!
                    if date > currentDate{
                        cell.viewForBG.backgroundColor = AppConstants.Colors.kAppThemeMediumRedColor
                        cell.lblMainStatus.text = "Preorder - \(model.displayOrderType)"
                    }
                }
                cell.lblMainStatus.textColor = .white
                cell.lblUserName.textColor = .white
            }else if model.status ?? "" == "Accepted"{
                if isDelayed{
                    cell.lblUserName.textColor = .white
                    cell.lblMainStatus.textColor = .white
                }
                if (model.orderType ?? "").lowercased() == "delivery"{
                    strStatus = "Mark as delivered"
                }else if (model.orderType ?? "").lowercased() == "pickup"{
                    strStatus = "Mark as collected"
                }else if (model.orderType ?? "").lowercased() == "dine in"{
                    strStatus = "Ready to serve"
                }
                if homeTheme == "theme4"{
                    if (model.orderType ?? "").lowercased() == "delivery"{
                        strStatus = "Mark as\ndelivered"
                    }else if (model.orderType ?? "").lowercased() == "pickup"{
                        strStatus = "Mark as\ncollected"
                    }else if (model.orderType ?? "").lowercased() == "dine in"{
                        strStatus = "Ready to\nserve"
                    }
                    cell.lblPaid.text = strStatus
                }
            }else{
                cell.lblStatus.superview?.isHidden = false
                cell.imgStatus.image  = UIImage.init(named: (model.status ?? "" == "Delivered") ? "ic_selected_green" : "ic_close_red")
                cell.lblStatus.textColor = (model.status ?? "" == "Delivered") ? AppConstants.Colors.kAppDarkGreenColor : AppConstants.Colors.kAppThemeRedColor
                cell.imgStatus.imageColor = (model.status ?? "" == "Delivered") ? AppConstants.Colors.kAppDarkGreenColor : AppConstants.Colors.kAppThemeRedColor
                if (model.orderType ?? "").lowercased() == "delivery"{
                    cell.lblStatus.text = (model.status ?? "" == "Delivered") ? "Delivered" : "Rejected"
                }else if (model.orderType ?? "").lowercased() == "pickup"{
                    cell.lblStatus.text = (model.status ?? "" == "Delivered") ? "Collected" : "Rejected"
                }else if (model.orderType ?? "").lowercased() == "dine in"{
                    cell.lblStatus.text = (model.status ?? "" == "Delivered") ? "Served" : "Rejected"
                }else{
                    cell.lblStatus.text = ""
                }
                cell.btnView.isHidden = true
            }
            cell.btnView.setTitle(strStatus, for: .normal)
            if homeTheme == "theme4"{
                cell.btnView.isHidden = true
            }
            return cell
        }
        var model:OrderModel!
        if collectionView == collectionAllOrders{
            model = (self.dictOrders[self.arrOrderSection[indexPath.section]] as! [OrderModel])[indexPath.row-1]
        }else{
            if collectionView == collectionDeliveryOrders || collectionView == collectionDeliveryOrdersTheme4{
                model = self.arrOngoingDeliveryOrders[indexPath.row-1]
            }else if collectionView == collectionCollectionOrders || collectionView == collectionCollectionOrdersTheme4{
                model = self.arrOngoingCollectionOrders[indexPath.row-1]
            }else if collectionView == collectionWaitingOrders || collectionView == collectionWaitingOrdersTheme4{
                model = self.arrOngoingWaitingOrders[indexPath.row-1]
            }
        }
        if model.orderStatusId ?? 0 == 3 || model.orderStatusId ?? 0 == 5 || model.orderStatusId ?? 0 == 9 || model.orderStatusId ?? 0 == 10 || model.orderStatusId ?? 0 == 19 || model.orderStatusId ?? 0 == 20{
            let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "CompletedOrderViewCell", for: indexPath) as! OrderViewCell
            cell.btnSelect.isHidden = true
            cell.constOrderTopSpace.constant = 10
            if model.customer?.name ?? "" == ""{
                cell.lblUserName.isHidden = true
            }else{
                cell.lblUserName.isHidden = false
                cell.lblUserName.text = model.customer?.name ?? ""
            }
            cell.lblOrderType?.superview?.isHidden = true
            if homeTheme == "theme3" || homeTheme == "theme4"{
                cell.lblOrderType?.superview?.isHidden = false
                cell.lblOrderType?.text = model.orderType?.first?.uppercased() ?? ""
                cell.lblMainStatus.text = "#\(model.displayOrderId)"
            }else{
                cell.lblMainStatus.text = "#\(model.displayOrderId)\n\(model.orderType ?? "")"
            }
            
            cell.imgStatus.image  = UIImage.init(named: "ic_selected_green")
            cell.lblStatus.textColor = AppConstants.Colors.kAppDarkGreenColor
            cell.imgStatus.imageColor = AppConstants.Colors.kAppDarkGreenColor
            if model.orderTypeId ?? 0 == 3{
                cell.lblStatus.text = "Delivered"
            }else if model.orderTypeId ?? 0 == 2{
                cell.lblStatus.text = "Collected"
            }else{
                cell.lblStatus.text = "Served"
            }
            if model.orderStatusId ?? 0 == 10{
                cell.lblStatus.text = "Cancelled"
                cell.imgStatus.image  = UIImage.init(named: "ic_close_red")
                cell.lblStatus.textColor = AppConstants.Colors.kAppThemeRedColor
                cell.imgStatus.imageColor = AppConstants.Colors.kAppThemeRedColor
            }
            if let status = model.orderStatus{
                cell.viewForBG.backgroundColor = UIColor.hexStr(hexStr: status.topColor ?? "", alpha: 1.0)
                cell.imgStatus.imageColor = .white
                cell.lblStatus.textColor = .white
                cell.imgStatus.imageColor = .white
                cell.lblMainStatus.textColor = .white
                cell.lblUserName.textColor = .white
            }else{
                cell.viewForBG.backgroundColor = AppConstants.Colors.kAppThemeBGColor
            }
            return cell
        }else{
            let cell = collectionView.dequeueReusableCell(withReuseIdentifier: homeTheme == "theme3" || homeTheme == "theme4" ? "OrderTheme3Cell" : "HomeOrderViewCell", for: indexPath) as! OrderViewCell
            let isContain = self.arrSelectedOrders.contains { (order) -> Bool in
                return model.id ?? 0 == order.id ?? 0
            }
            cell.btnSelect.isHidden = true
            cell.constOrderTopSpace.constant = 10
            if AppCommonMethods.fetchSiteSettingValue(key: "order_complete_mode") ?? "" != "auto"{
                if self.isServeSelected{
                    cell.constOrderTopSpace.constant = 40
                    if model.totalPaid ?? 0 >= model.total ?? 0 && model.total ?? 0 > 0{
                        cell.btnSelect.isHidden = false
                    }
                }
            }
            if isContain{
                cell.btnSelect.isSelected = true
            }else{
                cell.btnSelect.isSelected = false
            }
            cell.btnBack.accessibilityIdentifier = "\(indexPath.section)"
            cell.btnBack.tag = indexPath.row-1
            cell.btnView.accessibilityIdentifier = "\(indexPath.section)"
            cell.btnView.tag = indexPath.row-1
            cell.btnReadyToCollect.accessibilityIdentifier = "\(indexPath.section)"
            cell.btnReadyToCollect.tag = indexPath.row-1
            cell.btnCollected.accessibilityIdentifier = "\(indexPath.section)"
            cell.btnCollected.tag = indexPath.row-1
            cell.btnCollected.isHidden = true
            cell.btnReadyToCollect.isHidden = true
            if model.isBackEnabled{
                cell.constOrderLeadingSpace.constant = 8
            }else{
                cell.constOrderLeadingSpace.constant = 500
            }
            cell.lblMainStatus.textColor = .white
            cell.lblUserName.textColor = .white
            cell.lblMainStatus.text = "#\(model.displayOrderId)"
            if model.totalPaid ?? 0 >= model.total ?? 0 && model.total ?? 0 > 0{
                cell.imgStatus.image = UIImage.init(named: "more")
                cell.btnCollected.isHidden = false
                if model.orderTypeId ?? 0 == 2{
                    if AppCommonMethods.fetchSiteSettingValue(key: "is_ready_to_collect") ?? "" == "true" && model.orderStatusId ?? 0 != 6{
                        cell.btnReadyToCollect.isHidden = false
                        cell.btnReadyToCollect.setTitle("Ready To Collect", for: .normal)
                    }
                    cell.btnCollected.setTitle("Collected", for: .normal)
                }else if model.orderTypeId ?? 0 == 5{
                    cell.btnCollected.setTitle("Served", for: .normal)
                }else{
                    if AppCommonMethods.fetchSiteSettingValue(key: "is_on_the_way") ?? "" == "true" && model.orderStatusId ?? 0 != 6{
                        cell.btnReadyToCollect.isHidden = false
                        cell.btnReadyToCollect.setTitle("On The Way", for: .normal)
                        
                    }
                    cell.btnCollected.setTitle("Delivered", for: .normal)
                }
                cell.lblPaid.text = "Paid"
                cell.lblPaid.textColor = AppConstants.Colors.kAppMediumGreenColor
            }else if model.totalPaid ?? 0 > 0{
                cell.lblPaid.text = "Partial\nPaid"
                cell.lblPaid.textColor = AppConstants.Colors.kAppThemeRedColor
                cell.imgStatus.image = UIImage.init(named: "ic_cash")
            }else{
                cell.lblPaid.text = "Unpaid"
                cell.lblPaid.textColor = AppConstants.Colors.kAppThemeRedColor
                cell.imgStatus.image = UIImage.init(named: "ic_cash")
            }
            if model.isBackEnabled{
                cell.constOrderLeadingSpace.constant = 8
            }else{
                cell.constOrderLeadingSpace.constant = 500
            }
            if let status = model.orderStatus{
                cell.viewForBG.backgroundColor = UIColor.hexStr(hexStr: status.topColor ?? "", alpha: 1.0)
            }else{
                cell.viewForBG.backgroundColor = AppConstants.Colors.kAppMediumGreenColor
            }
            
            
            let userName = model.customer?.name ?? ""
            if homeTheme == "theme3" || homeTheme == "theme4"{
                cell.lblOrderType?.text = model.orderType?.first?.uppercased() ?? ""
                if userName.isEmpty{
                    cell.lblUserName.superview?.isHidden = true
                }else{
                    cell.lblUserName.superview?.isHidden = false
                    cell.lblUserName.text = userName
                }
                cell.lblPostcode.superview?.isHidden = true
                if model.orderTypeId ?? 0 == 3{
                    let postcode = model.customer?.postcode ?? ""
                    if !postcode.isEmpty{
                        cell.lblPostcode.superview?.isHidden = false
                        cell.lblPostcode.text = postcode
                    }
                }
                cell.lblPostcode.textColor = .white
                
            }else{
                cell.lblMainStatus.text = "#\(model.displayOrderId)\n\(model.orderType ?? "")"
            
                if userName.isEmpty{
                    cell.lblUserName.isHidden = true
                }else{
                    cell.lblUserName.isHidden = false
                    cell.lblUserName.text = userName
                }
            }
            cell.lblTime?.textColor = .white
            cell.lblTime?.superview?.isHidden = true
            if let date = model.createdDate{
                cell.startTimer(createdDate: date, theme: homeTheme)
            }
            cell.lblPaid.transform = CGAffineTransform(rotationAngle: CGFloat.pi / 2)
            return cell
        }
    }
    
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
        if collectionView == collectionHome{
            if arrHomeData[indexPath.row].type == .kCashDrawer{
                PrintManager.shared.connectToPrinterWithPrint(model: PaymentOrderModel(), controller: self)
            }else{
                self.parentVC.AddContainerView(data: arrHomeData[indexPath.row])
            }
            return
        }else if collectionView == collectionFloor{
            selectedFloorIndex = indexPath.row
            let width = self.view.frame.width-40
            collectionTable.contentOffset = CGPoint.init(x: width*CGFloat(selectedFloorIndex), y: 0)
            collectionFloor.reloadData()
            return
        }
        if collectionView == collectionOnlineOrders || collectionView == collectionOnlineOrdersTheme4{
            var model:WebOrderModel!
            if indexPath.section == 0{
                model = self.arrNewOrder[indexPath.row-1]
            }else if indexPath.section == 1{
                model = self.arrCurrentOrder[indexPath.row-1]
            }else{
                model = self.arrCompletedOrder[indexPath.row-1]
            }
            if let VC = OrderDetailVC.addToParentView(parentVC: self.parentVC, orderId: model.id ?? 0, orderType: model.orderType ?? ""){
                VC.delegate = self
            }
            return
        }
        if indexPath.row == 0{
            return
        }
        var aData:OrderModel!
        if collectionView == collectionAllOrders{
            aData = (self.dictOrders[self.arrOrderSection[indexPath.section]] as! [OrderModel])[indexPath.row-1]
        }else if collectionView == collectionDeliveryOrders || collectionView == collectionDeliveryOrdersTheme4{
            aData = self.arrOngoingDeliveryOrders[indexPath.row-1]
        }else if collectionView == collectionCollectionOrders || collectionView == collectionCollectionOrdersTheme4{
            aData = self.arrOngoingCollectionOrders[indexPath.row-1]
        }else if collectionView == collectionWaitingOrders || collectionView == collectionWaitingOrdersTheme4{
            aData = self.arrOngoingWaitingOrders[indexPath.row-1]
        }
        if self.isServeSelected{
            let index = self.arrSelectedOrders.firstIndex(where: { (model) -> Bool in
                return model.id ?? 0 == aData.id ?? 0
            })
            if aData.totalPaid ?? 0 >= aData.total ?? 0 && aData.total ?? 0 > 0{
                if index != nil{
                    self.arrSelectedOrders.remove(at: index!)
                }else{
                    self.arrSelectedOrders.append(aData)
                }
                self.collectionAllOrders.reloadData()
                self.collectionWaitingOrders.reloadData()
                self.collectionDeliveryOrders.reloadData()
                self.collectionCollectionOrders.reloadData()
            }
        }else{
            if aData.orderStatusId ?? 0 == 3 || aData.orderStatusId ?? 0 == 5 || aData.orderStatusId ?? 0 == 9 || aData.orderStatusId ?? 0 == 10 || aData.orderStatusId ?? 0 == 19 || aData.orderStatusId ?? 0 == 20{
                if let _ = OrderDetailVC.addToParentView(parentVC: self.parentVC, orderId: aData.id ?? 0, orderType: aData.orderType ?? "", orderData: aData){
                }
            }else{
                if let VC = CreateOrderVC.instance(){
                    VC.orderId = aData.id ?? 0
                    let orderType = OrderTypesModel.init()
                    orderType.id = aData.orderTypeId
                    orderType.type = aData.orderType
                    VC.orderData = aData
                    VC.orderType = orderType
                    parentVC.navigationController?.pushViewController(VC, animated: true)
                }
            }
        }
    }
}

//MARK:  AlertControllerDelegate
extension HomeViewController:AlertControllerDelegate{
    func alertButtonAction(index: Int, data:alertViewData,type:AlertType) {
        if index == 1{
            if selectedOrderType?.id ?? 0 == 6{
                CallSetOrderStatusAPI(status: "Delivered")
                return
            }
            if type == .kReadyToCollect{
                selectedOrder.orderStatusId = 6
                if Reachabilities.shared.isConnectedToNetwork() && AppConstants.DataSyncMode == "Auto"{
                    //AppCommonMethods.startProgressBar()
                    BGAPIExecution.shared.orderSaved = { orderId, message in
                        DispatchQueue.main.async {
                            AppCommonMethods.stopProgressBar()
                            print("Order \(orderId) Saved To Server")
                            self.checkForOrderType()
                        }
                    }
                    BGAPIExecution.shared.AddOrderToQueue(order: selectedOrder)
                }else{
                    SQLiteManage.SaveOrderIntoDatabase(order: selectedOrder, updated: 1)
                    checkForOrderType()
                }
            }else if type == .kMarkAsCollect{
                selectedOrder.orderStatusId = 5
                if Reachabilities.shared.isConnectedToNetwork() && AppConstants.DataSyncMode == "Auto"{
                    //AppCommonMethods.startProgressBar()
                    BGAPIExecution.shared.orderSaved = { orderId, message in
                        DispatchQueue.main.async {
                            AppCommonMethods.stopProgressBar()
                            print("Order \(orderId) Saved To Server")
                            self.checkForOrderType()
                        }
                    }
                    BGAPIExecution.shared.AddOrderToQueue(order: selectedOrder)
                }else{
                    SQLiteManage.SaveOrderIntoDatabase(order: selectedOrder, updated: 1)
                    checkForOrderType()
                }
            }else if type == .kRejectOrder || type == .kEnterUserPassword{
                if Reachabilities.shared.isConnectedToNetwork() && AppConstants.DataSyncMode == "Auto"{
                    if let status = CoreDataHelper.shared.fetchTableStatusData(name: "vacant").first{
                        //AppCommonMethods.startProgressBar()
                        AppCommonMethods.SaveTable(table: selectedTable, statusId: status.id ?? 0)
                        selectedOrder.orderStatusId = 10
                        selectedTable.tableStatusId = status.id ?? 0
                        selectedOrder.table = selectedTable
                        SQLiteManage.updateTableStatus(tableId: selectedTable.id ?? 0, statusId: status.id ?? 0, lastOrderId: 0, lastOrderTotal: 0, lastOrderTime: "", offline: 1)
                        BGAPIExecution.shared.orderSaved = { orderId, message in
                            DispatchQueue.main.async {
                                AppCommonMethods.stopProgressBar()
                                print("Order \(orderId) Saved To Server")
                                self.collectionTable.reloadData()
                            }
                        }
                        BGAPIExecution.shared.AddOrderToQueue(order: selectedOrder)
                        self.collectionTable.reloadData()
                    }else{
                        AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_NO_TABLESTATUS)
                    }
                }else{
                    if let status = CoreDataHelper.shared.fetchTableStatusData(name: "vacant").first{
                        selectedTable.tableStatus = status
                        selectedTable.tableStatusId = status.id ?? 0
                        selectedOrder.table = selectedTable
                        selectedOrder.orderStatusId = 10
                        SQLiteManage.updateTableStatus(tableId: selectedTable.id ?? 0, statusId: status.id, lastOrderId: 0, lastOrderTotal: 0, lastOrderTime: "", offline: 1)
                        SQLiteManage.SaveOrderIntoDatabase(order: selectedOrder, updated: 1)
                        AppCommonMethods.SaveTable(table: selectedTable, statusId: status.id)
                        self.collectionTable.reloadData()
                    }else{
                        AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_NO_TABLESTATUS)
                    }
                }
            }else{
                arrSelectedOrders.forEach { model in
                    model.orderStatusId = 5
                }
                if Reachabilities.shared.isConnectedToNetwork() && AppConstants.DataSyncMode == "Auto"{
                    AppCommonMethods.startProgressBar()
                    BGAPIExecution.shared.allDataPushed = {
                        DispatchQueue.main.async {
                            self.isServeSelected = false
                            self.arrSelectedOrders.removeAll()
                            AppCommonMethods.stopProgressBar()
                            self.checkForOrderType()
                        }
                    }
                    BGAPIExecution.shared.AddOrdersToQueue(arr: arrSelectedOrders)
                }else{
                    let arr = arrSelectedOrders.map { model in
                        return "\(model.id ?? 0)"
                    }
                    let strId = arr.joined(separator: ",")
                    _ = SQLiteManage.ExecuteQuery("UPDATE Orders SET is_archived = 1, is_update = 1 WHERE id IN (\(strId))")
                    self.isServeSelected = false
                    self.arrSelectedOrders.removeAll()
                    checkForOrderType()
                }
            }
        }
    }
}

//MARK:  NewOrderDelegate
extension HomeViewController:NewOrderDelegate{
    func orderTypeSelected(orderType: OrderTypesModel?) {
        
    }
    
    func requestForNewOrder(customer: CustomerModel, orderType: OrderTypesModel?, delivery: DeliveryChargeModel?, table: TableModel?, noOfGuest:Int?) {
        if let VC = CreateOrderVC.instance(){
            let index = AppConstants.arrOrderTypes.firstIndex { (model) -> Bool in
                return model.id ?? 0 == 1
            }
            if index != nil{
                VC.orderType = AppConstants.arrOrderTypes[index!]
                VC.selectedCustomer = customer
                VC.selectedTable = table!
                VC.noOfGuest = noOfGuest ?? 1
                self.navigationController?.pushViewController(VC, animated: true)
            }
        }
    }
    
    func goToOrderView(table: TableModel){
        if let type = AppConstants.arrOrderTypes.filter({ model in
            return model.id ?? 0 == 1
        }).first{
            let arrOrders = SQLiteManage.FetchOrdersForTable(table: table)
            if arrOrders.count > 1{
                if let VC = MultiOrderTableVC.instance{
                    VC.selectedTable = table
                    VC.arrOrders = arrOrders
                    self.navigationController?.pushViewController(VC, animated: true)
                }
            }else if arrOrders.count == 1{
                if let VC = CreateOrderVC.instance(){
                    VC.orderType = type
                    VC.selectedTable = table
                    VC.orderId = arrOrders[0].id ?? 0
                    self.navigationController?.pushViewController(VC, animated: true)
                }
            }else{
                self.FetchOrderDetail(table: table)
            }
        }
    }
}

extension HomeViewController:pageRefreshDelegate{
    func pageNeedToRefresh() {
        self.GetOnlineOrders(showLoader: false)
    }
}
