//
//  SideMenuVC.swift
//  EPOS
//
//  Created by Apple on 09/04/21.
//

import UIKit
import FirebaseMessaging

class SideMenuVC: UIViewController {
    
    //MARK: IBOutlets
    @IBOutlet weak var tblSideMenu:UITableView!
    @IBOutlet weak var viewForExpand:UIView!
    @IBOutlet weak var viewForContract:UIView!
    @IBOutlet weak var tblSideMenuOnExpand:UITableView!
    @IBOutlet weak var lblBusinessNAme:UILabel!
    @IBOutlet weak var lblUserName:UILabel!
    @IBOutlet weak var lblTime:UILabel!
    @IBOutlet weak var lblUserType:UILabel!
    @IBOutlet weak var lblModeExpand:UILabel!
    @IBOutlet weak var lblModeContract:UILabel!
    @IBOutlet weak var btnLogout:UIButtonX!
    @IBOutlet weak var imgBusinessLogo:UIImageView!
    @IBOutlet weak var imgBusinessLogoOnExpand:UIImageView!
    @IBOutlet weak var viewForContainer:UIView!
    @IBOutlet weak var viewForSideContainer:UIView!
    @IBOutlet weak var viewForSideBG:UIView!
    @IBOutlet weak var constSideViewLeadingSpace:NSLayoutConstraint!
    @IBOutlet weak var constContainerLeadingSpace:NSLayoutConstraint!
    
    //MARK: Instances
    var selectedMenuType = SideMenuCellType.kOverView
    var arrSideMenu = [SideMenuCellData]()
    var isAdminLogout = false
    var isSideMenuExpanded = true
    var sideMenuTap = false
    
    //MARK:  ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()
        
        // Do any additional setup after loading the view.
        setSideMenuItem()
        AddContainerView(data: arrSideMenu.first!)
        constSideViewLeadingSpace.constant = AppConstants.ScreenSize.SCREEN_WIDTH
        Timer.scheduledTimer(timeInterval: 30, target: self, selector: #selector(setSideBarTime), userInfo: nil, repeats: true)
    }
    
    override func viewWillAppear(_ animated: Bool) {
        lblUserName.text = AppConstants.userData?.username ?? ""
        lblBusinessNAme.text = AppConstants.businessData?.name ?? ""
        imgBusinessLogo.SetImageFromURL(strURL: AppCommonMethods.fetchSiteSettingValue(key: "logo", lowercased: false) ?? "")
        imgBusinessLogoOnExpand.SetImageFromURL(strURL: AppCommonMethods.fetchSiteSettingValue(key: "logo", lowercased: false) ?? "")
        setSideBarTime()
        setSideMenuItem()
        NotificationCenter.default.addObserver(self, selector: #selector(realodData), name: AppConstants.notifications.kCountFetched, object: nil)
        NotificationCenter.default.addObserver(self, selector: #selector(realodData), name: AppConstants.notifications.kDatabasePulled, object: nil)
        NotificationCenter.default.addObserver(self, selector: #selector(setSideBarTime), name: AppConstants.notifications.kAdminLogin, object: nil)
    }
    
    override func viewWillDisappear(_ animated: Bool) {
        NotificationCenter.default.removeObserver(self, name: AppConstants.notifications.kCountFetched, object: nil)
        NotificationCenter.default.removeObserver(self, name: AppConstants.notifications.kAdminLogin, object: nil)
        NotificationCenter.default.removeObserver(self, name: AppConstants.notifications.kDatabasePulled, object: nil)
    }
    
    //MARK: create viewcontroller instance
    static func instance()->SideMenuVC?{
        ManageCustomer.shared.fetchOfflineCustoemr()
        return UIStoryboard.init(name: "SideMenu", bundle: nil).instantiateViewController(withIdentifier: "SideMenuVC") as? SideMenuVC
    }
    
    //MARK: General Methods
    @objc func setSideBarTime(){
        if let timestamp = AppCommonMethods.readObjfromUserDefault(withKey: AppConstants.userDefaultKey.kLoginTimeStamp) as? Int{
            let currentTimestamp = Int(Date().timeIntervalSince1970)
            let diffrence = currentTimestamp - timestamp
            let hour = diffrence/(60*60)
            let minute = (diffrence - (hour*60*60))/60
            if AppConstants.isAdminLogin{
                lblUserType.textColor = .white
                lblUserName.textColor = .white
                lblUserType.superview?.backgroundColor = AppConstants.Colors.kAppThemeDarkRedColor
                lblUserType.text = String.init(format: "Admin • %0dh %0dm", hour,minute)
                btnLogout.setTitleColor(AppConstants.Colors.kAppThemeDarkRedColor, for: .normal)
                btnLogout.imageColor = AppConstants.Colors.kAppThemeDarkRedColor
            }else if AppConstants.isSupervisorLogin{
                lblUserType.textColor = .white
                lblUserName.textColor = .white
                lblUserType.superview?.backgroundColor = AppConstants.Colors.kAppThemeYellowColor
                lblUserType.text = String.init(format: "Supervisor • %0dh %0dm", hour,minute)
                btnLogout.setTitleColor(AppConstants.Colors.kAppThemeYellowColor, for: .normal)
                btnLogout.imageColor = AppConstants.Colors.kAppThemeYellowColor
            }else{
                lblUserType.textColor = AppConstants.Colors.kAppLightGrayColor
                lblUserName.textColor = AppConstants.Colors.kAppThemeTextColor
                lblUserType.superview?.backgroundColor = .white
                lblUserType.text = String.init(format: "Waiter • %0dh %0dm", hour,minute)
                btnLogout.setTitleColor(AppConstants.Colors.kAppThemeRedColor, for: .normal)
                btnLogout.imageColor = AppConstants.Colors.kAppThemeRedColor
            }
        }
        lblTime.text = "\(Date().getDateInString(format: "hh:mm a"))\nDevice Name: \(AppCommonMethods.readStringfromUserDefault(withKey: AppConstants.userDefaultKey.kDeviceName) ?? "")\nVersion: \((Bundle.main.infoDictionary?["CFBundleShortVersionString"] as? String) ?? "")"
        
    }
    
    @objc func realodData(){
        self.tblSideMenu.reloadData()
        self.tblSideMenuOnExpand.reloadData()
    }
    
    func setSideMenuItem(){
        arrSideMenu = [.init(title: "Home", image: "ic_home", type: SideMenuCellType.kOverView),.init(title: "New Order", image: "ic_new_order", type: SideMenuCellType.kNewOrder),.init(title: "Active Orders", image: "ic_order_print", type: SideMenuCellType.kActiveOrder),.init(title: "Online Orders", image: "ic_tiffintom", type: SideMenuCellType.kOnlineOrders),.init(title: "Tables", image: "ic_table", type: SideMenuCellType.kTables),.init(title: "Order History", image: "history", type: SideMenuCellType.kOrderHistory),.init(title: "Reservations", image: "reservation", type: SideMenuCellType.kReservation),.init(title: "Messages", image: "ic_message", type: SideMenuCellType.kMessages),.init(title: "Payments", image: "ic_payment", type: SideMenuCellType.kPayments),.init(title: "Cash Drawer", image: "ic_cash", type: SideMenuCellType.kCashDrawer),.init(title: "Settings", image: "settings", type: SideMenuCellType.kSettings),.init(title: "Vouchers", image: "voucher", type: SideMenuCellType.kVoucher),.init(title: "Table Status", image: "table-tatus", type: SideMenuCellType.kTableStatues),.init(title: "Customers", image: "customers", type: SideMenuCellType.kCustomers),.init(title: "Pull Data", image: "pull", type: .kPullDataBase),.init(title: "Pull Cutomer", image: "pull", type: .kPullCustomer),.init(title: "Change Theme", image: "ic_order_print", type: .kChangeTheme),.init(title: "Push Data", image: "push", type: .kPushDataBase)]
        if AppCommonMethods.fetchSiteSettingValue(key: "cloud_system") ?? "" == "no"{
            arrSideMenu.removeLast()
        }
        if AppCommonMethods.fetchSiteSettingValue(key: "is_dinein") ?? "" == "true" && AppConstants.userData?.permissions?.dinein?.actions?.list ?? 0 == 1{
            
        }else{
            arrSideMenu.remove(at: 12)
        }
        if AppConstants.userData?.permissions?.vouchers?.actions?.list ?? 0 == 1{
            
        }else{
            arrSideMenu.remove(at: 11)
        }
        if AppConstants.userData?.permissions?.cashdrawer?.actions?.list ?? 0 == 0{
            arrSideMenu.remove(at: 9)
        }
        if AppCommonMethods.fetchSiteSettingValue(key: "is_weborder") ?? "" == "true" && AppConstants.userData?.permissions?.weborder?.actions?.list ?? 0 == 1{
            
        }else{
            arrSideMenu.remove(at: 7)
        }
        if AppCommonMethods.fetchSiteSettingValue(key: "is_reservation") ?? "" == "true" && AppConstants.userData?.permissions?.reservation?.actions?.list ?? 0 == 1{
        }else{
            arrSideMenu.remove(at: 6)
        }
        if AppConstants.userData?.permissions?.orderHistory?.actions?.list ?? 0 == 1{
            
        }else{
            arrSideMenu.remove(at: 5)
        }
        if AppCommonMethods.fetchSiteSettingValue(key: "is_dinein") ?? "" == "true" && AppConstants.userData?.permissions?.dinein?.actions?.list ?? 0 == 1{
            
        }else{
            arrSideMenu.remove(at: 4)
        }
        if AppCommonMethods.fetchSiteSettingValue(key: "is_weborder") ?? "" == "true" && AppConstants.userData?.permissions?.weborder?.actions?.list ?? 0 == 1{
            
        }else{
            arrSideMenu.remove(at: 3)
        }
        if (AppCommonMethods.fetchSiteSettingValue(key: "is_waiting") ?? "" == "true" && AppConstants.userData?.permissions?.waiting?.actions?.list ?? 0 == 1) || (AppCommonMethods.fetchSiteSettingValue(key: "is_collection") ?? "" == "true" && AppConstants.userData?.permissions?.collection?.actions?.list ?? 0 == 1) || (AppCommonMethods.fetchSiteSettingValue(key: "is_delivery") ?? "" == "true" && AppConstants.userData?.permissions?.delivery?.actions?.list ?? 0 == 1) || (AppCommonMethods.fetchSiteSettingValue(key: "is_weborder") ?? "" == "true" && AppConstants.userData?.permissions?.weborder?.actions?.list ?? 0 == 1){
            
        }else{
            arrSideMenu.remove(at: 2)
            arrSideMenu.remove(at: 1)
        }
        if AppConstants.DataSyncMode == "Auto"{
            lblModeExpand.text = "A"
            lblModeExpand.backgroundColor = AppConstants.Colors.kAppDarkGreenColor
            lblModeContract.text = "A"
            lblModeContract.backgroundColor = AppConstants.Colors.kAppDarkGreenColor
        }else{
            lblModeExpand.text = "M"
            lblModeExpand.backgroundColor = AppConstants.Colors.kAppThemeDarkRedColor
            lblModeContract.text = "M"
            lblModeContract.backgroundColor = AppConstants.Colors.kAppThemeDarkRedColor
        }
        tblSideMenu.reloadData()
        self.tblSideMenuOnExpand.reloadData()
    }
    
    func AddContainerView(data:SideMenuCellData){
        setSideBarTime()
        for child in self.children{
            child.view.removeFromSuperview()
            child.removeFromParent()
        }
        self.view.backgroundColor = .white
        selectedMenuType = data.type
        switch data.type {
        case .kOverView:
            if let _ = HomeViewController.addToParentView(parentVC: self){
                
            }
        case .kTables:
            if let _ = DineInTableVC.addToParentView(parentVC: self){
                
            }
        case .kActiveOrder:
            if let _ = OrderListVC.addToParentView(parentVC: self, title: data.title){
                
            }
        case .kOnlineOrders:
            if let _ = OnlineOrdersVC.addToParentView(parentVC: self){
                
            }
        case .kTableStatues:
            if let _ = FreeTableVC.addToParentView(parentVC: self){
                
            }
        case .kCustomers:
            if let _ = CustomerListVC.addToParentView(parentVC: self){
                
            }
        case .kVoucher:
            if let _ = VouchersListVC.addToParentView(parentVC: self){
                
            }
        case .kReservation:
            if let _ = ReservationListVC.addToParentView(parentVC: self){
                
            }
        case .kDelivery:
            selectedMenuType = .kActiveOrder
            if let _ = OrderListVC.addToParentView(parentVC: self, title: data.title, orderTypeId: 3){
            }
        case .kCollection:
            selectedMenuType = .kActiveOrder
            if let _ = OrderListVC.addToParentView(parentVC: self, title: data.title, orderTypeId: 2){
            }
        case .kWaiting:
            selectedMenuType = .kActiveOrder
            if let _ = OrderListVC.addToParentView(parentVC: self, title: data.title, orderTypeId: 5){
            }
        case .kSettings:
            if let _ = SettingsMainVC.addToParentView(parentVC: self){
            }
        case .kOrderHistory:
            if let _ = OrderHistoryVC.addToParentView(parentVC: self){
            }
        case .kMessages:
            self.view.backgroundColor = AppConstants.Colors.kAppThemeBGColor
            if let _ = ChatListVC.addToParentView(parentVC: self){
            }
        case .kPayments:
            self.view.backgroundColor = AppConstants.Colors.kAppThemeBGColor
            if let _ = PaymentMainVC.addToParentView(parentVC: self){
            }
        case .kMenu:
            if let _ = MenuViewController.addToParentView(parentVC: self){
            }
        default:
            break
        }
        tblSideMenu.reloadData()
        self.tblSideMenuOnExpand.reloadData()
    }
    
    //MARK:  Button Actions
    @IBAction func btnExpandAction(_ sender:UIButton){
        self.constContainerLeadingSpace.constant = 245
        isSideMenuExpanded = true
        sideMenuTap = true
        UIView.animate(withDuration: 0.2, delay: 0, options: .allowAnimatedContent) {
            self.view.layoutIfNeeded()
            self.viewForContract.isHidden = true
            self.viewForExpand.isHidden = false
            for VC in self.children{
                VC.view.frame = CGRect.init(x: 0, y: 0, width: self.viewForContainer.frame.width, height: self.viewForContainer.frame.height)
            }
        } completion: { status in
            self.sideMenuTap = false
        }
    }
    
    @IBAction func btnContractAction(_ sender:UIButton){
        constContainerLeadingSpace.constant = 100
        isSideMenuExpanded = false
        sideMenuTap = true
        UIView.animate(withDuration: 0.2, delay: 0, options: .allowAnimatedContent) {
            self.view.layoutIfNeeded()
            self.viewForContract.isHidden = false
            self.viewForExpand.isHidden = true
            for VC in self.children{
                VC.view.frame = CGRect.init(x: 0, y: 0, width: self.viewForContainer.frame.width, height: self.viewForContainer.frame.height)
            }
        } completion: { status in
            self.sideMenuTap = false
        }
    }
    
    @IBAction func btnAdminLogout(_ sender:UIButton){
        isAdminLogout = true
        var setting = AlertSetting()
        setting.alertMessage = AppConstants.GlobalAlert.kAdminLogout
        setting.alertTitle = AppConstants.GlobalAlert.ALERT_BTN_LOGOUT.capitalized
        setting.confirmTitle = AppConstants.GlobalAlert.ALERT_BTN_LOGOUT
        setting.cancelTitle = AppConstants.GlobalAlert.ALERT_BTN_CANCEL
        setting.confirmBGColor = AppConstants.Colors.kAppDarkGrayColor
        setting.cancelBGColor = AppConstants.Colors.kAppLightGrayColor
        if let VC = AlertViewController.showPopup(parentVC: self, setting: setting){
            VC.delegate = self
        }
    }
    
    @IBAction func btnUserLogout(_ sender:UIButton){
        isAdminLogout = false
        var setting = AlertSetting()
        setting.alertMessage = AppConstants.GlobalAlert.kUserLogout
        setting.alertTitle = AppConstants.GlobalAlert.ALERT_BTN_LOGOUT.capitalized
        setting.confirmTitle = AppConstants.GlobalAlert.ALERT_BTN_LOGOUT
        setting.cancelTitle = AppConstants.GlobalAlert.ALERT_BTN_CANCEL
        setting.confirmBGColor = AppConstants.Colors.kAppDarkGrayColor
        setting.cancelBGColor = AppConstants.Colors.kAppLightGrayColor
        if let VC = AlertViewController.showPopup(parentVC: self, setting: setting){
            VC.delegate = self
        }
    }
    
    func checkPushOrder(){
        if Reachabilities.shared.isConnectedToNetwork(){
            let predicate = NSPredicate.init(format: "is_update == 1 AND business_id == %d", AppConstants.businessData?.id ?? 0)
            let orderCount = SQLiteManage.fetchCountOfTable(whereString: "WHERE is_update = \(1) AND business_id = \(AppConstants.businessData?.id ?? 0)", tableName: "Orders")
            let reservationCount = CoreDataHelper.shared.numberOfRowOfEntity(name: "Reservations",predict: predicate) ?? 0
            if (orderCount > 0 || reservationCount > 0) && AppCommonMethods.fetchSiteSettingValue(key: "cloud_system") ?? "" == "yes"{
                AppCommonMethods.startProgressBar(strMessage: "Pushing data\nto the server...")
                BGAPIExecution.shared.allDataPushed = {
                    DispatchQueue.main.async {
                        AppCommonMethods.stopProgressBar()
                        self.CallLogoutAPI()
                    }
                }
                BGAPIExecution.shared.fetchAllOfflineOrders()
            }else{
                CallLogoutAPI()
            }
        }
    }
    
    func CallLogoutAPI(){
        let dictParam = [String:String]()
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam, urlString: "\(AppConstants.APIURL.kUser)\(AppConstants.userData?.id ?? 0)/logout", method: "GET", isAdminURL: true, saveAdminToken: false) { (message, result) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                if let response = result as? NSDictionary{
                    let jsonDecoder = JSONDecoder()
                    if let data = AppCommonMethods.convertToJson(object: response), let _ = try? jsonDecoder.decode(UserModel.self, from: data){
                        if self.isAdminLogout{
                            self.AdminLogout()
                        }else{
                            self.userLogout()
                        }
                        return
                    }
                }
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: message, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    
                }
            }
        }
    }
    
    func PullDataFromServer(isCustomer:Bool = false){
        if isCustomer{
            AppCommonMethods.startProgressBar(view: self.view,strMessage: "Pulling customer\nfrom server...")
            AppCommonMethods.PullCustomerFromServer {
                DispatchQueue.main.async {
                    AppCommonMethods.stopProgressBar(view: self.view)
                    NotificationCenter.default.post(name: AppConstants.notifications.kDatabasePulled, object: nil)
                    self.setSideMenuItem()
                }
            }
        }else{
            AppCommonMethods.startProgressBar(view: self.view,strMessage: "Pulling data\nfrom server...")
            AppCommonMethods.PullDataFromServer {
                AppCommonMethods.FetchOrdersList{
                    DispatchQueue.main.async {
                        AppCommonMethods.stopProgressBar(view: self.view)
                        NotificationCenter.default.post(name: AppConstants.notifications.kDatabasePulled, object: nil)
                        self.setSideMenuItem()
                        if let VC = SideMenuVC.instance(){
                            let navc = UINavigationController.init(rootViewController: VC)
                            navc.isNavigationBarHidden = true
                            AppCommonMethods.appDelegate.window!.rootViewController = navc
                        }
                    }
                }
            }
        }
    }
}

//MARK:  UITableViewDataSource
extension SideMenuVC:UITableViewDelegate,UITableViewDataSource{
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return arrSideMenu.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "SideMenuListCell", for: indexPath) as! SideMenuListCell
        cell.lblTitle?.text = arrSideMenu[indexPath.row].title
        cell.lblCount?.isHidden = true
        cell.viewNotification?.isHidden = true
        cell.imgView.image = UIImage.init(named: arrSideMenu[indexPath.row].image)
        cell.constCountWidth?.constant = 0
        if arrSideMenu[indexPath.row].type == .kMessages{
            if AppConstants.chatCount != 0{
                cell.lblCount?.isHidden = false
                cell.viewNotification?.isHidden = false
                cell.lblCount?.text = "\(AppConstants.chatCount)"
                cell.constCountWidth?.constant = 20
            }
        }else if arrSideMenu[indexPath.row].type == .kOnlineOrders{
            if AppConstants.orderCount != 0{
                cell.lblCount?.isHidden = false
                cell.viewNotification?.isHidden = false
                cell.lblCount?.text = "\(AppConstants.orderCount)"
                cell.constCountWidth?.constant = 20
            }
        }else if arrSideMenu[indexPath.row].type == .kReservation{
            let count = AppConstants.reservationCount + (CoreDataHelper.shared.numberOfRowOfEntity(name: "Reservations", predict: NSPredicate.init(format: "reservation_date_time >= %d AND reservation_status_id == 1",Int(Date().timeIntervalSince1970))) ?? 0)
            if count != 0{
                cell.lblCount?.isHidden = false
                cell.viewNotification?.isHidden = false
                cell.lblCount?.text = "\(count)"
                cell.constCountWidth?.constant = 20
            }
        }
        
        if arrSideMenu[indexPath.row].type == selectedMenuType{
            cell.lblTitle?.textColor = .white
            cell.lblCount?.textColor = AppConstants.Colors.kAppThemeAquaColor
            cell.lblCount?.backgroundColor = .white
            cell.imgView.imageColor = .white
            cell.imgView.superview?.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
        }else{
            cell.lblCount?.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
            cell.lblTitle?.textColor = AppConstants.Colors.kAppThemeTextColor
            cell.lblCount?.textColor = .white
            cell.imgView.imageColor = AppConstants.Colors.kAppThemeTextColor
            cell.imgView.superview?.backgroundColor = .white
        }
        
        return cell
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        setSideBarTime()
        if arrSideMenu[indexPath.row].type == SideMenuCellType.kNewOrder{
            if let VC = OrderTypeSelectionVc.showPopup(parentVC: self){
                VC.delegate = self
            }
        }else if arrSideMenu[indexPath.row].type == .kCashDrawer{
            if AppCommonMethods.fetchSiteSettingValue(key: "cashdrawer_password_enable") ?? "" == "true"{
                var setting = AlertSetting()
                setting.alertTitle = AppConstants.GlobalAlert.ALERT_ENTER_PASSWORD
                setting.alertMessage = "Please enter your password to open cash drawer"
                setting.textPlcaeholder = "password"
                setting.type = .kEnterUserPassword
                setting.textType = .default
                if let VC = AlertViewController.showPopup(parentVC: self, setting: setting){
                    VC.delegate = self
                }
            }else{
                PrintManager.shared.connectToPrinterWithPrint(model: PaymentOrderModel(), controller: self)
            }
        }else if arrSideMenu[indexPath.row].type == .kPullDataBase{
            if AppCommonMethods.fetchSiteSettingValue(key: "cloud_system") ?? "" == "no"{
                let onGoingOrderCount = SQLiteManage.fetchCountOfTable(whereString: "WHERE order_status_id in (1,2,3,4,6,7,9,12) AND business_id = '\(AppConstants.businessData?.id ?? 0)'", tableName: "Orders")
                if onGoingOrderCount == 0{
                    self.PullDataFromServer()
                }else{
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: "Please complete all orders before polling the data.", withActionsTitle: ["CONFIRM"]) { (index) in
                        
                    }
                }
            }else{
                let onGoingOrderCount = SQLiteManage.fetchCountOfTable(whereString: "WHERE order_status_id in (1,2,3,4,6,7,9,12) AND business_id = '\(AppConstants.businessData?.id ?? 0)'", tableName: "Orders")
                if onGoingOrderCount == 0{
                    AppCommonMethods.startProgressBar(strMessage: "Pushing data\nto the server...")
                    BGAPIExecution.shared.allDataPushed = {
                        DispatchQueue.main.async {
                            AppCommonMethods.stopProgressBar()
                            NotificationCenter.default.post(name: AppConstants.notifications.kDatabasePushed, object: nil)
                            self.PullDataFromServer()
                        }
                    }
                    BGAPIExecution.shared.fetchAllOfflineOrders()
                }else{
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: "Please complete all orders before polling the data.", withActionsTitle: ["CONFIRM"]) { (index) in
                        
                    }
                }
            }
            return
        }else if arrSideMenu[indexPath.row].type == .kPullCustomer{
            if AppCommonMethods.fetchSiteSettingValue(key: "cloud_system") ?? "" == "no"{
                self.PullDataFromServer(isCustomer: true)
            }else{
                AppCommonMethods.startProgressBar(strMessage: "Pushing data\nto the server...")
                BGAPIExecution.shared.allDataPushed = {
                    DispatchQueue.main.async {
                        AppCommonMethods.stopProgressBar()
                        NotificationCenter.default.post(name: AppConstants.notifications.kDatabasePushed, object: nil)
                        self.PullDataFromServer(isCustomer: true)
                    }
                }
                BGAPIExecution.shared.fetchAllOfflineOrders()
            }
            //RealmManager().fetchAllOrders()
        }else if arrSideMenu[indexPath.row].type == .kPushDataBase{
            AppCommonMethods.startProgressBar(strMessage: "Pushing data\nto the server...")
            BGAPIExecution.shared.allDataPushed = {
                DispatchQueue.main.async {
                    AppCommonMethods.stopProgressBar()
                    NotificationCenter.default.post(name: AppConstants.notifications.kDatabasePushed, object: nil)
                }
            }
            BGAPIExecution.shared.fetchAllOfflineOrders()
            return
        }else if arrSideMenu[indexPath.row].type == .kChangeTheme{
            if let _ = ChangeThemeVC.showPopup(parentVC: self){
                
            }
        }else{
            AddContainerView(data: arrSideMenu[indexPath.row])
        }
    }
    
    func AdminLogout(){
        Messaging.messaging().unsubscribe(fromTopic: "business_\(AppConstants.businessData?.id ?? 0)") { error in
            if error != nil{
                print("Error topic: \(error?.localizedDescription ?? "")")
            }else{
                print("Unsubscribed to topic")
            }
        }
        if AppConstants.DataSyncMode == "Auto"{
            CustomAudioPlayer.stopOrderAudio()
            CustomAudioPlayer.stopDelayOrderAudio()
        }else{
            BadgeManager.shared?.userLogout()
        }
        CoreDataHelper.shared.DeleteAdminData()
        AppCommonMethods.removefromUserDefault(withKey: AppConstants.userDefaultKey.kBusinessData)
        AppCommonMethods.removefromUserDefault(withKey: AppConstants.userDefaultKey.kUserData)
        AppCommonMethods.removefromUserDefault(withKey: AppConstants.userDefaultKey.kHeaderToken)
        AppCommonMethods.removefromUserDefault(withKey: AppConstants.userDefaultKey.kRefreshHeaderToken)
        AppCommonMethods.removefromUserDefault(withKey: AppConstants.userDefaultKey.kAdminHeaderToken)
        AppCommonMethods.removefromUserDefault(withKey: AppConstants.userDefaultKey.kAdminRefreshHeaderToken)
        AppCommonMethods.removefromUserDefault(withKey: AppConstants.userDefaultKey.kAdminUserData)
        AppConstants.isAdminLogin = false
        AppConstants.isSupervisorLogin = false
        SocketService.shared?.stopSocket()
        SocketService.destroySharedManager()
        if let VC = AdminLoginVC.instance(){
            let navc = UINavigationController.init(rootViewController: VC)
            navc.isNavigationBarHidden = true
            AppConstants.appDelegate.window?.rootViewController = navc
        }
    }
    
    func userLogout(){
        if AppConstants.DataSyncMode == "Auto"{
            CustomAudioPlayer.stopOrderAudio()
            CustomAudioPlayer.stopDelayOrderAudio()
        }else{
            BadgeManager.shared?.userLogout()
        }
        AppCommonMethods.removefromUserDefault(withKey: AppConstants.userDefaultKey.kUserData)
        AppCommonMethods.removefromUserDefault(withKey: AppConstants.userDefaultKey.kHeaderToken)
        AppCommonMethods.removefromUserDefault(withKey: AppConstants.userDefaultKey.kRefreshHeaderToken)
        AppConstants.isAdminLogin = false
        AppConstants.isSupervisorLogin = false
        SocketService.shared?.stopSocket()
        SocketService.destroySharedManager()
        if let VC = LoginVC.instance(){
            let navc = UINavigationController.init(rootViewController: VC)
            navc.isNavigationBarHidden = true
            AppConstants.appDelegate.window?.rootViewController = navc
        }
    }
}

//MARK:  AlertControllerDelegate
extension SideMenuVC:AlertControllerDelegate{
    func alertButtonAction(index: Int,data:alertViewData,type:AlertType) {
        if type == .kEnterUserPassword{
            PrintManager.shared.connectToPrinterWithPrint(model: PaymentOrderModel(), controller: self)
        }else{
            if index == 1{
                checkPushOrder()
            }
        }
    }
}

//MARK:  NewOrderDelegate
extension SideMenuVC:NewOrderDelegate{
    func orderTypeSelected(orderType:OrderTypesModel?){
        if let VC = NewOrderVC.showPopup(parentVC: self, orderType: orderType){
            VC.delegate = self
        }
    }
    
    func requestForNewOrder(customer: CustomerModel, orderType: OrderTypesModel?, delivery: DeliveryChargeModel?, table: TableModel?, noOfGuest:Int?) {
        if let VC = CreateOrderVC.instance(){
            VC.orderType = orderType!
            VC.selectedCustomer = customer
            VC.deliveryCharge = delivery?.charge ?? 0
            VC.distance = delivery?.distance ?? 0
            self.navigationController?.pushViewController(VC, animated: true)
        }
    }
}
