/*
 * Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* Automatically generated nanopb header */
/* Generated by nanopb-0.3.9.9 */

#ifndef PB_FIREBASE_PERF_V1_PERF_METRIC_NANOPB_H_INCLUDED
#define PB_FIREBASE_PERF_V1_PERF_METRIC_NANOPB_H_INCLUDED
#include <nanopb/pb.h>

/* @@protoc_insertion_point(includes) */
#if PB_PROTO_HEADER_VERSION != 30
#error Regenerate this file with the current version of nanopb generator.
#endif


/* Enum definitions */
typedef enum _firebase_perf_v1_ApplicationProcessState {
    firebase_perf_v1_ApplicationProcessState_APPLICATION_PROCESS_STATE_UNKNOWN = 0,
    firebase_perf_v1_ApplicationProcessState_FOREGROUND = 1,
    firebase_perf_v1_ApplicationProcessState_BACKGROUND = 2,
    firebase_perf_v1_ApplicationProcessState_FOREGROUND_BACKGROUND = 3
} firebase_perf_v1_ApplicationProcessState;
#define _firebase_perf_v1_ApplicationProcessState_MIN firebase_perf_v1_ApplicationProcessState_APPLICATION_PROCESS_STATE_UNKNOWN
#define _firebase_perf_v1_ApplicationProcessState_MAX firebase_perf_v1_ApplicationProcessState_FOREGROUND_BACKGROUND
#define _firebase_perf_v1_ApplicationProcessState_ARRAYSIZE ((firebase_perf_v1_ApplicationProcessState)(firebase_perf_v1_ApplicationProcessState_FOREGROUND_BACKGROUND+1))

typedef enum _firebase_perf_v1_SessionVerbosity {
    firebase_perf_v1_SessionVerbosity_SESSION_VERBOSITY_NONE = 0,
    firebase_perf_v1_SessionVerbosity_GAUGES_AND_SYSTEM_EVENTS = 1
} firebase_perf_v1_SessionVerbosity;
#define _firebase_perf_v1_SessionVerbosity_MIN firebase_perf_v1_SessionVerbosity_SESSION_VERBOSITY_NONE
#define _firebase_perf_v1_SessionVerbosity_MAX firebase_perf_v1_SessionVerbosity_GAUGES_AND_SYSTEM_EVENTS
#define _firebase_perf_v1_SessionVerbosity_ARRAYSIZE ((firebase_perf_v1_SessionVerbosity)(firebase_perf_v1_SessionVerbosity_GAUGES_AND_SYSTEM_EVENTS+1))

typedef enum _firebase_perf_v1_VisibilityState {
    firebase_perf_v1_VisibilityState_VISIBILITY_STATE_UNKNOWN = 0,
    firebase_perf_v1_VisibilityState_VISIBLE = 1,
    firebase_perf_v1_VisibilityState_HIDDEN = 2,
    firebase_perf_v1_VisibilityState_PRERENDER = 3,
    firebase_perf_v1_VisibilityState_UNLOADED = 4
} firebase_perf_v1_VisibilityState;
#define _firebase_perf_v1_VisibilityState_MIN firebase_perf_v1_VisibilityState_VISIBILITY_STATE_UNKNOWN
#define _firebase_perf_v1_VisibilityState_MAX firebase_perf_v1_VisibilityState_UNLOADED
#define _firebase_perf_v1_VisibilityState_ARRAYSIZE ((firebase_perf_v1_VisibilityState)(firebase_perf_v1_VisibilityState_UNLOADED+1))

typedef enum _firebase_perf_v1_ServiceWorkerStatus {
    firebase_perf_v1_ServiceWorkerStatus_SERVICE_WORKER_STATUS_UNKNOWN = 0,
    firebase_perf_v1_ServiceWorkerStatus_UNSUPPORTED = 1,
    firebase_perf_v1_ServiceWorkerStatus_CONTROLLED = 2,
    firebase_perf_v1_ServiceWorkerStatus_UNCONTROLLED = 3
} firebase_perf_v1_ServiceWorkerStatus;
#define _firebase_perf_v1_ServiceWorkerStatus_MIN firebase_perf_v1_ServiceWorkerStatus_SERVICE_WORKER_STATUS_UNKNOWN
#define _firebase_perf_v1_ServiceWorkerStatus_MAX firebase_perf_v1_ServiceWorkerStatus_UNCONTROLLED
#define _firebase_perf_v1_ServiceWorkerStatus_ARRAYSIZE ((firebase_perf_v1_ServiceWorkerStatus)(firebase_perf_v1_ServiceWorkerStatus_UNCONTROLLED+1))

typedef enum _firebase_perf_v1_EffectiveConnectionType {
    firebase_perf_v1_EffectiveConnectionType_EFFECTIVE_CONNECTION_TYPE_UNKNOWN = 0,
    firebase_perf_v1_EffectiveConnectionType_EFFECTIVE_CONNECTION_TYPE_SLOW_2G = 1,
    firebase_perf_v1_EffectiveConnectionType_EFFECTIVE_CONNECTION_TYPE_2G = 2,
    firebase_perf_v1_EffectiveConnectionType_EFFECTIVE_CONNECTION_TYPE_3G = 3,
    firebase_perf_v1_EffectiveConnectionType_EFFECTIVE_CONNECTION_TYPE_4G = 4
} firebase_perf_v1_EffectiveConnectionType;
#define _firebase_perf_v1_EffectiveConnectionType_MIN firebase_perf_v1_EffectiveConnectionType_EFFECTIVE_CONNECTION_TYPE_UNKNOWN
#define _firebase_perf_v1_EffectiveConnectionType_MAX firebase_perf_v1_EffectiveConnectionType_EFFECTIVE_CONNECTION_TYPE_4G
#define _firebase_perf_v1_EffectiveConnectionType_ARRAYSIZE ((firebase_perf_v1_EffectiveConnectionType)(firebase_perf_v1_EffectiveConnectionType_EFFECTIVE_CONNECTION_TYPE_4G+1))

typedef enum _firebase_perf_v1_NetworkRequestMetric_HttpMethod {
    firebase_perf_v1_NetworkRequestMetric_HttpMethod_HTTP_METHOD_UNKNOWN = 0,
    firebase_perf_v1_NetworkRequestMetric_HttpMethod_GET = 1,
    firebase_perf_v1_NetworkRequestMetric_HttpMethod_PUT = 2,
    firebase_perf_v1_NetworkRequestMetric_HttpMethod_POST = 3,
    firebase_perf_v1_NetworkRequestMetric_HttpMethod_DELETE = 4,
    firebase_perf_v1_NetworkRequestMetric_HttpMethod_HEAD = 5,
    firebase_perf_v1_NetworkRequestMetric_HttpMethod_PATCH = 6,
    firebase_perf_v1_NetworkRequestMetric_HttpMethod_OPTIONS = 7,
    firebase_perf_v1_NetworkRequestMetric_HttpMethod_TRACE = 8,
    firebase_perf_v1_NetworkRequestMetric_HttpMethod_CONNECT = 9
} firebase_perf_v1_NetworkRequestMetric_HttpMethod;
#define _firebase_perf_v1_NetworkRequestMetric_HttpMethod_MIN firebase_perf_v1_NetworkRequestMetric_HttpMethod_HTTP_METHOD_UNKNOWN
#define _firebase_perf_v1_NetworkRequestMetric_HttpMethod_MAX firebase_perf_v1_NetworkRequestMetric_HttpMethod_CONNECT
#define _firebase_perf_v1_NetworkRequestMetric_HttpMethod_ARRAYSIZE ((firebase_perf_v1_NetworkRequestMetric_HttpMethod)(firebase_perf_v1_NetworkRequestMetric_HttpMethod_CONNECT+1))

typedef enum _firebase_perf_v1_NetworkRequestMetric_NetworkClientErrorReason {
    firebase_perf_v1_NetworkRequestMetric_NetworkClientErrorReason_NETWORK_CLIENT_ERROR_REASON_UNKNOWN = 0,
    firebase_perf_v1_NetworkRequestMetric_NetworkClientErrorReason_GENERIC_CLIENT_ERROR = 1
} firebase_perf_v1_NetworkRequestMetric_NetworkClientErrorReason;
#define _firebase_perf_v1_NetworkRequestMetric_NetworkClientErrorReason_MIN firebase_perf_v1_NetworkRequestMetric_NetworkClientErrorReason_NETWORK_CLIENT_ERROR_REASON_UNKNOWN
#define _firebase_perf_v1_NetworkRequestMetric_NetworkClientErrorReason_MAX firebase_perf_v1_NetworkRequestMetric_NetworkClientErrorReason_GENERIC_CLIENT_ERROR
#define _firebase_perf_v1_NetworkRequestMetric_NetworkClientErrorReason_ARRAYSIZE ((firebase_perf_v1_NetworkRequestMetric_NetworkClientErrorReason)(firebase_perf_v1_NetworkRequestMetric_NetworkClientErrorReason_GENERIC_CLIENT_ERROR+1))

typedef enum _firebase_perf_v1_NetworkConnectionInfo_NetworkType {
    firebase_perf_v1_NetworkConnectionInfo_NetworkType_NONE = -1,
    firebase_perf_v1_NetworkConnectionInfo_NetworkType_MOBILE = 0,
    firebase_perf_v1_NetworkConnectionInfo_NetworkType_WIFI = 1,
    firebase_perf_v1_NetworkConnectionInfo_NetworkType_MOBILE_MMS = 2,
    firebase_perf_v1_NetworkConnectionInfo_NetworkType_MOBILE_SUPL = 3,
    firebase_perf_v1_NetworkConnectionInfo_NetworkType_MOBILE_DUN = 4,
    firebase_perf_v1_NetworkConnectionInfo_NetworkType_MOBILE_HIPRI = 5,
    firebase_perf_v1_NetworkConnectionInfo_NetworkType_WIMAX = 6,
    firebase_perf_v1_NetworkConnectionInfo_NetworkType_BLUETOOTH = 7,
    firebase_perf_v1_NetworkConnectionInfo_NetworkType_DUMMY = 8,
    firebase_perf_v1_NetworkConnectionInfo_NetworkType_ETHERNET = 9,
    firebase_perf_v1_NetworkConnectionInfo_NetworkType_MOBILE_FOTA = 10,
    firebase_perf_v1_NetworkConnectionInfo_NetworkType_MOBILE_IMS = 11,
    firebase_perf_v1_NetworkConnectionInfo_NetworkType_MOBILE_CBS = 12,
    firebase_perf_v1_NetworkConnectionInfo_NetworkType_WIFI_P2P = 13,
    firebase_perf_v1_NetworkConnectionInfo_NetworkType_MOBILE_IA = 14,
    firebase_perf_v1_NetworkConnectionInfo_NetworkType_MOBILE_EMERGENCY = 15,
    firebase_perf_v1_NetworkConnectionInfo_NetworkType_PROXY = 16,
    firebase_perf_v1_NetworkConnectionInfo_NetworkType_VPN = 17
} firebase_perf_v1_NetworkConnectionInfo_NetworkType;
#define _firebase_perf_v1_NetworkConnectionInfo_NetworkType_MIN firebase_perf_v1_NetworkConnectionInfo_NetworkType_NONE
#define _firebase_perf_v1_NetworkConnectionInfo_NetworkType_MAX firebase_perf_v1_NetworkConnectionInfo_NetworkType_VPN
#define _firebase_perf_v1_NetworkConnectionInfo_NetworkType_ARRAYSIZE ((firebase_perf_v1_NetworkConnectionInfo_NetworkType)(firebase_perf_v1_NetworkConnectionInfo_NetworkType_VPN+1))

typedef enum _firebase_perf_v1_NetworkConnectionInfo_MobileSubtype {
    firebase_perf_v1_NetworkConnectionInfo_MobileSubtype_UNKNOWN_MOBILE_SUBTYPE = 0,
    firebase_perf_v1_NetworkConnectionInfo_MobileSubtype_GPRS = 1,
    firebase_perf_v1_NetworkConnectionInfo_MobileSubtype_EDGE = 2,
    firebase_perf_v1_NetworkConnectionInfo_MobileSubtype_UMTS = 3,
    firebase_perf_v1_NetworkConnectionInfo_MobileSubtype_CDMA = 4,
    firebase_perf_v1_NetworkConnectionInfo_MobileSubtype_EVDO_0 = 5,
    firebase_perf_v1_NetworkConnectionInfo_MobileSubtype_EVDO_A = 6,
    firebase_perf_v1_NetworkConnectionInfo_MobileSubtype_RTT = 7,
    firebase_perf_v1_NetworkConnectionInfo_MobileSubtype_HSDPA = 8,
    firebase_perf_v1_NetworkConnectionInfo_MobileSubtype_HSUPA = 9,
    firebase_perf_v1_NetworkConnectionInfo_MobileSubtype_HSPA = 10,
    firebase_perf_v1_NetworkConnectionInfo_MobileSubtype_IDEN = 11,
    firebase_perf_v1_NetworkConnectionInfo_MobileSubtype_EVDO_B = 12,
    firebase_perf_v1_NetworkConnectionInfo_MobileSubtype_LTE = 13,
    firebase_perf_v1_NetworkConnectionInfo_MobileSubtype_EHRPD = 14,
    firebase_perf_v1_NetworkConnectionInfo_MobileSubtype_HSPAP = 15,
    firebase_perf_v1_NetworkConnectionInfo_MobileSubtype_GSM = 16,
    firebase_perf_v1_NetworkConnectionInfo_MobileSubtype_TD_SCDMA = 17,
    firebase_perf_v1_NetworkConnectionInfo_MobileSubtype_IWLAN = 18,
    firebase_perf_v1_NetworkConnectionInfo_MobileSubtype_LTE_CA = 19,
    firebase_perf_v1_NetworkConnectionInfo_MobileSubtype_COMBINED = 100
} firebase_perf_v1_NetworkConnectionInfo_MobileSubtype;
#define _firebase_perf_v1_NetworkConnectionInfo_MobileSubtype_MIN firebase_perf_v1_NetworkConnectionInfo_MobileSubtype_UNKNOWN_MOBILE_SUBTYPE
#define _firebase_perf_v1_NetworkConnectionInfo_MobileSubtype_MAX firebase_perf_v1_NetworkConnectionInfo_MobileSubtype_COMBINED
#define _firebase_perf_v1_NetworkConnectionInfo_MobileSubtype_ARRAYSIZE ((firebase_perf_v1_NetworkConnectionInfo_MobileSubtype)(firebase_perf_v1_NetworkConnectionInfo_MobileSubtype_COMBINED+1))

typedef enum _firebase_perf_v1_TransportInfo_DispatchDestination {
    firebase_perf_v1_TransportInfo_DispatchDestination_SOURCE_UNKNOWN = 0,
    firebase_perf_v1_TransportInfo_DispatchDestination_FL_LEGACY_V1 = 1
} firebase_perf_v1_TransportInfo_DispatchDestination;
#define _firebase_perf_v1_TransportInfo_DispatchDestination_MIN firebase_perf_v1_TransportInfo_DispatchDestination_SOURCE_UNKNOWN
#define _firebase_perf_v1_TransportInfo_DispatchDestination_MAX firebase_perf_v1_TransportInfo_DispatchDestination_FL_LEGACY_V1
#define _firebase_perf_v1_TransportInfo_DispatchDestination_ARRAYSIZE ((firebase_perf_v1_TransportInfo_DispatchDestination)(firebase_perf_v1_TransportInfo_DispatchDestination_FL_LEGACY_V1+1))

/* Struct definitions */
typedef struct _firebase_perf_v1_AndroidApplicationInfo {
    pb_bytes_array_t *package_name;
    pb_bytes_array_t *sdk_version;
    pb_bytes_array_t *version_name;
/* @@protoc_insertion_point(struct:firebase_perf_v1_AndroidApplicationInfo) */
} firebase_perf_v1_AndroidApplicationInfo;

typedef struct _firebase_perf_v1_ApplicationInfo_CustomAttributesEntry {
    pb_bytes_array_t *key;
    pb_bytes_array_t *value;
/* @@protoc_insertion_point(struct:firebase_perf_v1_ApplicationInfo_CustomAttributesEntry) */
} firebase_perf_v1_ApplicationInfo_CustomAttributesEntry;

typedef struct _firebase_perf_v1_NetworkRequestMetric_CustomAttributesEntry {
    pb_bytes_array_t *key;
    pb_bytes_array_t *value;
/* @@protoc_insertion_point(struct:firebase_perf_v1_NetworkRequestMetric_CustomAttributesEntry) */
} firebase_perf_v1_NetworkRequestMetric_CustomAttributesEntry;

typedef struct _firebase_perf_v1_PerfSession {
    pb_bytes_array_t *session_id;
    pb_size_t session_verbosity_count;
    firebase_perf_v1_SessionVerbosity *session_verbosity;
/* @@protoc_insertion_point(struct:firebase_perf_v1_PerfSession) */
} firebase_perf_v1_PerfSession;

typedef struct _firebase_perf_v1_TraceMetric_CustomAttributesEntry {
    pb_bytes_array_t *key;
    pb_bytes_array_t *value;
/* @@protoc_insertion_point(struct:firebase_perf_v1_TraceMetric_CustomAttributesEntry) */
} firebase_perf_v1_TraceMetric_CustomAttributesEntry;

typedef struct _firebase_perf_v1_AndroidMemoryReading {
    bool has_client_time_us;
    int64_t client_time_us;
    bool has_used_app_java_heap_memory_kb;
    int32_t used_app_java_heap_memory_kb;
/* @@protoc_insertion_point(struct:firebase_perf_v1_AndroidMemoryReading) */
} firebase_perf_v1_AndroidMemoryReading;

typedef struct _firebase_perf_v1_CpuMetricReading {
    bool has_client_time_us;
    int64_t client_time_us;
    bool has_user_time_us;
    int64_t user_time_us;
    bool has_system_time_us;
    int64_t system_time_us;
/* @@protoc_insertion_point(struct:firebase_perf_v1_CpuMetricReading) */
} firebase_perf_v1_CpuMetricReading;

typedef struct _firebase_perf_v1_GaugeMetadata {
    pb_bytes_array_t *process_name;
    bool has_cpu_clock_rate_khz;
    int32_t cpu_clock_rate_khz;
    bool has_device_ram_size_kb;
    int32_t device_ram_size_kb;
    bool has_max_app_java_heap_memory_kb;
    int32_t max_app_java_heap_memory_kb;
    bool has_max_encouraged_app_java_heap_memory_kb;
    int32_t max_encouraged_app_java_heap_memory_kb;
    bool has_cpu_processor_count;
    int32_t cpu_processor_count;
/* @@protoc_insertion_point(struct:firebase_perf_v1_GaugeMetadata) */
} firebase_perf_v1_GaugeMetadata;

typedef struct _firebase_perf_v1_IosMemoryReading {
    bool has_client_time_us;
    int64_t client_time_us;
    bool has_used_app_heap_memory_kb;
    int32_t used_app_heap_memory_kb;
    bool has_free_app_heap_memory_kb;
    int32_t free_app_heap_memory_kb;
/* @@protoc_insertion_point(struct:firebase_perf_v1_IosMemoryReading) */
} firebase_perf_v1_IosMemoryReading;

typedef struct _firebase_perf_v1_NetworkConnectionInfo {
    bool has_network_type;
    firebase_perf_v1_NetworkConnectionInfo_NetworkType network_type;
    bool has_mobile_subtype;
    firebase_perf_v1_NetworkConnectionInfo_MobileSubtype mobile_subtype;
/* @@protoc_insertion_point(struct:firebase_perf_v1_NetworkConnectionInfo) */
} firebase_perf_v1_NetworkConnectionInfo;

typedef struct _firebase_perf_v1_NetworkRequestMetric {
    pb_bytes_array_t *url;
    bool has_http_method;
    firebase_perf_v1_NetworkRequestMetric_HttpMethod http_method;
    bool has_request_payload_bytes;
    int64_t request_payload_bytes;
    bool has_response_payload_bytes;
    int64_t response_payload_bytes;
    bool has_http_response_code;
    int32_t http_response_code;
    pb_bytes_array_t *response_content_type;
    bool has_client_start_time_us;
    int64_t client_start_time_us;
    bool has_time_to_request_completed_us;
    int64_t time_to_request_completed_us;
    bool has_time_to_response_initiated_us;
    int64_t time_to_response_initiated_us;
    bool has_time_to_response_completed_us;
    int64_t time_to_response_completed_us;
    bool has_network_client_error_reason;
    firebase_perf_v1_NetworkRequestMetric_NetworkClientErrorReason network_client_error_reason;
    pb_size_t custom_attributes_count;
    struct _firebase_perf_v1_NetworkRequestMetric_CustomAttributesEntry *custom_attributes;
    pb_size_t perf_sessions_count;
    struct _firebase_perf_v1_PerfSession *perf_sessions;
/* @@protoc_insertion_point(struct:firebase_perf_v1_NetworkRequestMetric) */
} firebase_perf_v1_NetworkRequestMetric;

typedef struct _firebase_perf_v1_TraceMetric {
    pb_bytes_array_t *name;
    bool has_is_auto;
    bool is_auto;
    bool has_client_start_time_us;
    int64_t client_start_time_us;
    bool has_duration_us;
    int64_t duration_us;
    pb_size_t counters_count;
    struct _firebase_perf_v1_TraceMetric_CountersEntry *counters;
    pb_size_t subtraces_count;
    struct _firebase_perf_v1_TraceMetric *subtraces;
    pb_size_t custom_attributes_count;
    struct _firebase_perf_v1_TraceMetric_CustomAttributesEntry *custom_attributes;
    pb_size_t perf_sessions_count;
    struct _firebase_perf_v1_PerfSession *perf_sessions;
/* @@protoc_insertion_point(struct:firebase_perf_v1_TraceMetric) */
} firebase_perf_v1_TraceMetric;

typedef struct _firebase_perf_v1_TraceMetric_CountersEntry {
    pb_bytes_array_t *key;
    bool has_value;
    int64_t value;
/* @@protoc_insertion_point(struct:firebase_perf_v1_TraceMetric_CountersEntry) */
} firebase_perf_v1_TraceMetric_CountersEntry;

typedef struct _firebase_perf_v1_TransportInfo {
    bool has_dispatch_destination;
    firebase_perf_v1_TransportInfo_DispatchDestination dispatch_destination;
/* @@protoc_insertion_point(struct:firebase_perf_v1_TransportInfo) */
} firebase_perf_v1_TransportInfo;

typedef struct _firebase_perf_v1_WebApplicationInfo {
    pb_bytes_array_t *sdk_version;
    pb_bytes_array_t *page_url;
    bool has_service_worker_status;
    firebase_perf_v1_ServiceWorkerStatus service_worker_status;
    bool has_visibility_state;
    firebase_perf_v1_VisibilityState visibility_state;
    bool has_effective_connection_type;
    firebase_perf_v1_EffectiveConnectionType effective_connection_type;
/* @@protoc_insertion_point(struct:firebase_perf_v1_WebApplicationInfo) */
} firebase_perf_v1_WebApplicationInfo;

typedef struct _firebase_perf_v1_GaugeMetric {
    pb_bytes_array_t *session_id;
    pb_size_t cpu_metric_readings_count;
    struct _firebase_perf_v1_CpuMetricReading *cpu_metric_readings;
    bool has_gauge_metadata;
    firebase_perf_v1_GaugeMetadata gauge_metadata;
    pb_size_t android_memory_readings_count;
    struct _firebase_perf_v1_AndroidMemoryReading *android_memory_readings;
    pb_size_t ios_memory_readings_count;
    struct _firebase_perf_v1_IosMemoryReading *ios_memory_readings;
/* @@protoc_insertion_point(struct:firebase_perf_v1_GaugeMetric) */
} firebase_perf_v1_GaugeMetric;

typedef struct _firebase_perf_v1_IosApplicationInfo {
    pb_bytes_array_t *sdk_version;
    pb_bytes_array_t *bundle_short_version;
    pb_bytes_array_t *mcc_mnc;
    bool has_network_connection_info;
    firebase_perf_v1_NetworkConnectionInfo network_connection_info;
/* @@protoc_insertion_point(struct:firebase_perf_v1_IosApplicationInfo) */
} firebase_perf_v1_IosApplicationInfo;

typedef struct _firebase_perf_v1_ApplicationInfo {
    pb_bytes_array_t *google_app_id;
    pb_bytes_array_t *app_instance_id;
    bool has_android_app_info;
    firebase_perf_v1_AndroidApplicationInfo android_app_info;
    bool has_ios_app_info;
    firebase_perf_v1_IosApplicationInfo ios_app_info;
    bool has_application_process_state;
    firebase_perf_v1_ApplicationProcessState application_process_state;
    pb_size_t custom_attributes_count;
    struct _firebase_perf_v1_ApplicationInfo_CustomAttributesEntry *custom_attributes;
    bool has_web_app_info;
    firebase_perf_v1_WebApplicationInfo web_app_info;
/* @@protoc_insertion_point(struct:firebase_perf_v1_ApplicationInfo) */
} firebase_perf_v1_ApplicationInfo;

typedef struct _firebase_perf_v1_PerfMetric {
    bool has_application_info;
    firebase_perf_v1_ApplicationInfo application_info;
    bool has_trace_metric;
    firebase_perf_v1_TraceMetric trace_metric;
    bool has_network_request_metric;
    firebase_perf_v1_NetworkRequestMetric network_request_metric;
    bool has_gauge_metric;
    firebase_perf_v1_GaugeMetric gauge_metric;
    bool has_transport_info;
    firebase_perf_v1_TransportInfo transport_info;
/* @@protoc_insertion_point(struct:firebase_perf_v1_PerfMetric) */
} firebase_perf_v1_PerfMetric;

/* Default values for struct fields */
extern const firebase_perf_v1_NetworkConnectionInfo_NetworkType firebase_perf_v1_NetworkConnectionInfo_network_type_default;
extern const firebase_perf_v1_NetworkConnectionInfo_MobileSubtype firebase_perf_v1_NetworkConnectionInfo_mobile_subtype_default;

/* Initializer values for message structs */
#define firebase_perf_v1_PerfMetric_init_default {false, firebase_perf_v1_ApplicationInfo_init_default, false, firebase_perf_v1_TraceMetric_init_default, false, firebase_perf_v1_NetworkRequestMetric_init_default, false, firebase_perf_v1_GaugeMetric_init_default, false, firebase_perf_v1_TransportInfo_init_default}
#define firebase_perf_v1_TraceMetric_init_default {NULL, false, 0, false, 0, false, 0, 0, NULL, 0, NULL, 0, NULL, 0, NULL}
#define firebase_perf_v1_TraceMetric_CountersEntry_init_default {NULL, false, 0}
#define firebase_perf_v1_TraceMetric_CustomAttributesEntry_init_default {NULL, NULL}
#define firebase_perf_v1_NetworkRequestMetric_init_default {NULL, false, _firebase_perf_v1_NetworkRequestMetric_HttpMethod_MIN, false, 0, false, 0, false, 0, NULL, false, 0, false, 0, false, 0, false, 0, false, _firebase_perf_v1_NetworkRequestMetric_NetworkClientErrorReason_MIN, 0, NULL, 0, NULL}
#define firebase_perf_v1_NetworkRequestMetric_CustomAttributesEntry_init_default {NULL, NULL}
#define firebase_perf_v1_PerfSession_init_default {NULL, 0, NULL}
#define firebase_perf_v1_GaugeMetric_init_default {NULL, 0, NULL, false, firebase_perf_v1_GaugeMetadata_init_default, 0, NULL, 0, NULL}
#define firebase_perf_v1_CpuMetricReading_init_default {false, 0, false, 0, false, 0}
#define firebase_perf_v1_IosMemoryReading_init_default {false, 0, false, 0, false, 0}
#define firebase_perf_v1_AndroidMemoryReading_init_default {false, 0, false, 0}
#define firebase_perf_v1_GaugeMetadata_init_default {NULL, false, 0, false, 0, false, 0, false, 0, false, 0}
#define firebase_perf_v1_ApplicationInfo_init_default {NULL, NULL, false, firebase_perf_v1_AndroidApplicationInfo_init_default, false, firebase_perf_v1_IosApplicationInfo_init_default, false, _firebase_perf_v1_ApplicationProcessState_MIN, 0, NULL, false, firebase_perf_v1_WebApplicationInfo_init_default}
#define firebase_perf_v1_ApplicationInfo_CustomAttributesEntry_init_default {NULL, NULL}
#define firebase_perf_v1_WebApplicationInfo_init_default {NULL, NULL, false, _firebase_perf_v1_ServiceWorkerStatus_MIN, false, _firebase_perf_v1_VisibilityState_MIN, false, _firebase_perf_v1_EffectiveConnectionType_MIN}
#define firebase_perf_v1_AndroidApplicationInfo_init_default {NULL, NULL, NULL}
#define firebase_perf_v1_NetworkConnectionInfo_init_default {false, firebase_perf_v1_NetworkConnectionInfo_NetworkType_NONE, false, firebase_perf_v1_NetworkConnectionInfo_MobileSubtype_UNKNOWN_MOBILE_SUBTYPE}
#define firebase_perf_v1_IosApplicationInfo_init_default {NULL, NULL, NULL, false, firebase_perf_v1_NetworkConnectionInfo_init_default}
#define firebase_perf_v1_TransportInfo_init_default {false, _firebase_perf_v1_TransportInfo_DispatchDestination_MIN}
#define firebase_perf_v1_PerfMetric_init_zero    {false, firebase_perf_v1_ApplicationInfo_init_zero, false, firebase_perf_v1_TraceMetric_init_zero, false, firebase_perf_v1_NetworkRequestMetric_init_zero, false, firebase_perf_v1_GaugeMetric_init_zero, false, firebase_perf_v1_TransportInfo_init_zero}
#define firebase_perf_v1_TraceMetric_init_zero   {NULL, false, 0, false, 0, false, 0, 0, NULL, 0, NULL, 0, NULL, 0, NULL}
#define firebase_perf_v1_TraceMetric_CountersEntry_init_zero {NULL, false, 0}
#define firebase_perf_v1_TraceMetric_CustomAttributesEntry_init_zero {NULL, NULL}
#define firebase_perf_v1_NetworkRequestMetric_init_zero {NULL, false, _firebase_perf_v1_NetworkRequestMetric_HttpMethod_MIN, false, 0, false, 0, false, 0, NULL, false, 0, false, 0, false, 0, false, 0, false, _firebase_perf_v1_NetworkRequestMetric_NetworkClientErrorReason_MIN, 0, NULL, 0, NULL}
#define firebase_perf_v1_NetworkRequestMetric_CustomAttributesEntry_init_zero {NULL, NULL}
#define firebase_perf_v1_PerfSession_init_zero   {NULL, 0, NULL}
#define firebase_perf_v1_GaugeMetric_init_zero   {NULL, 0, NULL, false, firebase_perf_v1_GaugeMetadata_init_zero, 0, NULL, 0, NULL}
#define firebase_perf_v1_CpuMetricReading_init_zero {false, 0, false, 0, false, 0}
#define firebase_perf_v1_IosMemoryReading_init_zero {false, 0, false, 0, false, 0}
#define firebase_perf_v1_AndroidMemoryReading_init_zero {false, 0, false, 0}
#define firebase_perf_v1_GaugeMetadata_init_zero {NULL, false, 0, false, 0, false, 0, false, 0, false, 0}
#define firebase_perf_v1_ApplicationInfo_init_zero {NULL, NULL, false, firebase_perf_v1_AndroidApplicationInfo_init_zero, false, firebase_perf_v1_IosApplicationInfo_init_zero, false, _firebase_perf_v1_ApplicationProcessState_MIN, 0, NULL, false, firebase_perf_v1_WebApplicationInfo_init_zero}
#define firebase_perf_v1_ApplicationInfo_CustomAttributesEntry_init_zero {NULL, NULL}
#define firebase_perf_v1_WebApplicationInfo_init_zero {NULL, NULL, false, _firebase_perf_v1_ServiceWorkerStatus_MIN, false, _firebase_perf_v1_VisibilityState_MIN, false, _firebase_perf_v1_EffectiveConnectionType_MIN}
#define firebase_perf_v1_AndroidApplicationInfo_init_zero {NULL, NULL, NULL}
#define firebase_perf_v1_NetworkConnectionInfo_init_zero {false, _firebase_perf_v1_NetworkConnectionInfo_NetworkType_MIN, false, _firebase_perf_v1_NetworkConnectionInfo_MobileSubtype_MIN}
#define firebase_perf_v1_IosApplicationInfo_init_zero {NULL, NULL, NULL, false, firebase_perf_v1_NetworkConnectionInfo_init_zero}
#define firebase_perf_v1_TransportInfo_init_zero {false, _firebase_perf_v1_TransportInfo_DispatchDestination_MIN}

/* Field tags (for use in manual encoding/decoding) */
#define firebase_perf_v1_AndroidApplicationInfo_package_name_tag 1
#define firebase_perf_v1_AndroidApplicationInfo_sdk_version_tag 2
#define firebase_perf_v1_AndroidApplicationInfo_version_name_tag 3
#define firebase_perf_v1_ApplicationInfo_CustomAttributesEntry_key_tag 1
#define firebase_perf_v1_ApplicationInfo_CustomAttributesEntry_value_tag 2
#define firebase_perf_v1_NetworkRequestMetric_CustomAttributesEntry_key_tag 1
#define firebase_perf_v1_NetworkRequestMetric_CustomAttributesEntry_value_tag 2
#define firebase_perf_v1_PerfSession_session_id_tag 1
#define firebase_perf_v1_PerfSession_session_verbosity_tag 2
#define firebase_perf_v1_TraceMetric_CustomAttributesEntry_key_tag 1
#define firebase_perf_v1_TraceMetric_CustomAttributesEntry_value_tag 2
#define firebase_perf_v1_AndroidMemoryReading_client_time_us_tag 1
#define firebase_perf_v1_AndroidMemoryReading_used_app_java_heap_memory_kb_tag 2
#define firebase_perf_v1_CpuMetricReading_client_time_us_tag 1
#define firebase_perf_v1_CpuMetricReading_user_time_us_tag 2
#define firebase_perf_v1_CpuMetricReading_system_time_us_tag 3
#define firebase_perf_v1_GaugeMetadata_process_name_tag 1
#define firebase_perf_v1_GaugeMetadata_cpu_clock_rate_khz_tag 2
#define firebase_perf_v1_GaugeMetadata_cpu_processor_count_tag 6
#define firebase_perf_v1_GaugeMetadata_device_ram_size_kb_tag 3
#define firebase_perf_v1_GaugeMetadata_max_app_java_heap_memory_kb_tag 4
#define firebase_perf_v1_GaugeMetadata_max_encouraged_app_java_heap_memory_kb_tag 5
#define firebase_perf_v1_IosMemoryReading_client_time_us_tag 1
#define firebase_perf_v1_IosMemoryReading_used_app_heap_memory_kb_tag 2
#define firebase_perf_v1_IosMemoryReading_free_app_heap_memory_kb_tag 3
#define firebase_perf_v1_NetworkConnectionInfo_network_type_tag 1
#define firebase_perf_v1_NetworkConnectionInfo_mobile_subtype_tag 2
#define firebase_perf_v1_NetworkRequestMetric_url_tag 1
#define firebase_perf_v1_NetworkRequestMetric_http_method_tag 2
#define firebase_perf_v1_NetworkRequestMetric_request_payload_bytes_tag 3
#define firebase_perf_v1_NetworkRequestMetric_response_payload_bytes_tag 4
#define firebase_perf_v1_NetworkRequestMetric_network_client_error_reason_tag 11
#define firebase_perf_v1_NetworkRequestMetric_http_response_code_tag 5
#define firebase_perf_v1_NetworkRequestMetric_response_content_type_tag 6
#define firebase_perf_v1_NetworkRequestMetric_client_start_time_us_tag 7
#define firebase_perf_v1_NetworkRequestMetric_time_to_request_completed_us_tag 8
#define firebase_perf_v1_NetworkRequestMetric_time_to_response_initiated_us_tag 9
#define firebase_perf_v1_NetworkRequestMetric_time_to_response_completed_us_tag 10
#define firebase_perf_v1_NetworkRequestMetric_custom_attributes_tag 12
#define firebase_perf_v1_NetworkRequestMetric_perf_sessions_tag 13
#define firebase_perf_v1_TraceMetric_name_tag    1
#define firebase_perf_v1_TraceMetric_is_auto_tag 2
#define firebase_perf_v1_TraceMetric_client_start_time_us_tag 4
#define firebase_perf_v1_TraceMetric_duration_us_tag 5
#define firebase_perf_v1_TraceMetric_counters_tag 6
#define firebase_perf_v1_TraceMetric_subtraces_tag 7
#define firebase_perf_v1_TraceMetric_custom_attributes_tag 8
#define firebase_perf_v1_TraceMetric_perf_sessions_tag 9
#define firebase_perf_v1_TraceMetric_CountersEntry_key_tag 1
#define firebase_perf_v1_TraceMetric_CountersEntry_value_tag 2
#define firebase_perf_v1_TransportInfo_dispatch_destination_tag 1
#define firebase_perf_v1_WebApplicationInfo_sdk_version_tag 1
#define firebase_perf_v1_WebApplicationInfo_page_url_tag 2
#define firebase_perf_v1_WebApplicationInfo_service_worker_status_tag 3
#define firebase_perf_v1_WebApplicationInfo_visibility_state_tag 4
#define firebase_perf_v1_WebApplicationInfo_effective_connection_type_tag 5
#define firebase_perf_v1_GaugeMetric_session_id_tag 1
#define firebase_perf_v1_GaugeMetric_gauge_metadata_tag 3
#define firebase_perf_v1_GaugeMetric_cpu_metric_readings_tag 2
#define firebase_perf_v1_GaugeMetric_android_memory_readings_tag 4
#define firebase_perf_v1_GaugeMetric_ios_memory_readings_tag 5
#define firebase_perf_v1_IosApplicationInfo_sdk_version_tag 2
#define firebase_perf_v1_IosApplicationInfo_bundle_short_version_tag 3
#define firebase_perf_v1_IosApplicationInfo_mcc_mnc_tag 4
#define firebase_perf_v1_IosApplicationInfo_network_connection_info_tag 5
#define firebase_perf_v1_ApplicationInfo_google_app_id_tag 1
#define firebase_perf_v1_ApplicationInfo_app_instance_id_tag 2
#define firebase_perf_v1_ApplicationInfo_android_app_info_tag 3
#define firebase_perf_v1_ApplicationInfo_ios_app_info_tag 4
#define firebase_perf_v1_ApplicationInfo_web_app_info_tag 7
#define firebase_perf_v1_ApplicationInfo_application_process_state_tag 5
#define firebase_perf_v1_ApplicationInfo_custom_attributes_tag 6
#define firebase_perf_v1_PerfMetric_application_info_tag 1
#define firebase_perf_v1_PerfMetric_trace_metric_tag 2
#define firebase_perf_v1_PerfMetric_network_request_metric_tag 3
#define firebase_perf_v1_PerfMetric_gauge_metric_tag 4
#define firebase_perf_v1_PerfMetric_transport_info_tag 5

/* Struct field encoding specification for nanopb */
extern const pb_field_t firebase_perf_v1_PerfMetric_fields[6];
extern const pb_field_t firebase_perf_v1_TraceMetric_fields[9];
extern const pb_field_t firebase_perf_v1_TraceMetric_CountersEntry_fields[3];
extern const pb_field_t firebase_perf_v1_TraceMetric_CustomAttributesEntry_fields[3];
extern const pb_field_t firebase_perf_v1_NetworkRequestMetric_fields[14];
extern const pb_field_t firebase_perf_v1_NetworkRequestMetric_CustomAttributesEntry_fields[3];
extern const pb_field_t firebase_perf_v1_PerfSession_fields[3];
extern const pb_field_t firebase_perf_v1_GaugeMetric_fields[6];
extern const pb_field_t firebase_perf_v1_CpuMetricReading_fields[4];
extern const pb_field_t firebase_perf_v1_IosMemoryReading_fields[4];
extern const pb_field_t firebase_perf_v1_AndroidMemoryReading_fields[3];
extern const pb_field_t firebase_perf_v1_GaugeMetadata_fields[7];
extern const pb_field_t firebase_perf_v1_ApplicationInfo_fields[8];
extern const pb_field_t firebase_perf_v1_ApplicationInfo_CustomAttributesEntry_fields[3];
extern const pb_field_t firebase_perf_v1_WebApplicationInfo_fields[6];
extern const pb_field_t firebase_perf_v1_AndroidApplicationInfo_fields[4];
extern const pb_field_t firebase_perf_v1_NetworkConnectionInfo_fields[3];
extern const pb_field_t firebase_perf_v1_IosApplicationInfo_fields[5];
extern const pb_field_t firebase_perf_v1_TransportInfo_fields[2];

/* Maximum encoded size of messages (where known) */
/* firebase_perf_v1_PerfMetric_size depends on runtime parameters */
/* firebase_perf_v1_TraceMetric_size depends on runtime parameters */
/* firebase_perf_v1_TraceMetric_CountersEntry_size depends on runtime parameters */
/* firebase_perf_v1_TraceMetric_CustomAttributesEntry_size depends on runtime parameters */
/* firebase_perf_v1_NetworkRequestMetric_size depends on runtime parameters */
/* firebase_perf_v1_NetworkRequestMetric_CustomAttributesEntry_size depends on runtime parameters */
/* firebase_perf_v1_PerfSession_size depends on runtime parameters */
/* firebase_perf_v1_GaugeMetric_size depends on runtime parameters */
#define firebase_perf_v1_CpuMetricReading_size   33
#define firebase_perf_v1_IosMemoryReading_size   33
#define firebase_perf_v1_AndroidMemoryReading_size 22
/* firebase_perf_v1_GaugeMetadata_size depends on runtime parameters */
/* firebase_perf_v1_ApplicationInfo_size depends on runtime parameters */
/* firebase_perf_v1_ApplicationInfo_CustomAttributesEntry_size depends on runtime parameters */
/* firebase_perf_v1_WebApplicationInfo_size depends on runtime parameters */
/* firebase_perf_v1_AndroidApplicationInfo_size depends on runtime parameters */
#define firebase_perf_v1_NetworkConnectionInfo_size 13
/* firebase_perf_v1_IosApplicationInfo_size depends on runtime parameters */
#define firebase_perf_v1_TransportInfo_size      2

/* Message IDs (where set with "msgid" option) */
#ifdef PB_MSGID

#define PERF_METRIC_MESSAGES \


#endif

/* @@protoc_insertion_point(eof) */

#endif
