//
//  IQKeyboardToolbarConstants.swift
//  https://github.com/hackiftekhar/IQKeyboardToolbarManager
//  Copyright (c) 2013-24 Iftekhar Qurashi.
//
//  Permission is hereby granted, free of charge, to any person obtaining a copy
//  of this software and associated documentation files (the "Software"), to deal
//  in the Software without restriction, including without limitation the rights
//  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//  copies of the Software, and to permit persons to whom the Software is
//  furnished to do so, subject to the following conditions:
//
//  The above copyright notice and this permission notice shall be included in
//  all copies or substantial portions of the Software.
//
//  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//  THE SOFTWARE.

import Foundation

// MARK: IQKeyboardToolbarManageBehavior

/**
`IQAutoToolbarBySubviews`
Creates Toolbar according to subview's hierarchy of textInputView's in view.

`IQAutoToolbarByTag`
Creates Toolbar according to tag property of textInputView's.

`IQAutoToolbarByPosition`
Creates Toolbar according to the y,x position of textInputView in it's superview coordinate.
*/
@available(iOSApplicationExtension, unavailable)
@objc public enum IQKeyboardToolbarManageBehavior: Int {
    case bySubviews
    case byTag
    case byPosition
}

@available(*, unavailable, renamed: "IQKeyboardToolbarManageBehavior")
@objc public enum IQAutoToolbarManageBehavior: Int {
    case bySubviews
    case byTag
    case byPosition
}

/**
 `IQPreviousNextDisplayModeDefault`
 Show NextPrevious when there are more than 1 textInputView otherwise hide.

 `IQPreviousNextDisplayModeAlwaysHide`
 Do not show NextPrevious buttons in any case.
 
 `IQPreviousNextDisplayModeAlwaysShow`
 Always show nextPrevious buttons,
 if there are more than 1 textInputView then both buttons will be visible but will be shown as disabled.
 */
@available(iOSApplicationExtension, unavailable)
@objc public enum IQPreviousNextDisplayMode: Int {
    case `default`
    case alwaysHide
    case alwaysShow
}
