(function ($) {
    "use strict";

    // Spinner
    var spinner = function () {
        setTimeout(function () {
            if ($('#spinner').length > 0) {
                $('#spinner').removeClass('show');
            }
        }, 1);
    };
    spinner();
    
    
    // Initiate the wowjs
    new WOW().init();


    // Sticky Navbar
    $(window).scroll(function () {
        if ($(this).scrollTop() > 45) {
            $('.navbar').addClass('sticky-top shadow-sm');
        } else {
            $('.navbar').removeClass('sticky-top shadow-sm');
        }
    });
    
    
    // Dropdown on mouse hover
    const $dropdown = $(".dropdown");
    const $dropdownToggle = $(".dropdown-toggle");
    const $dropdownMenu = $(".dropdown-menu");
    const showClass = "show";
    
    $(window).on("load resize", function() {
        if (this.matchMedia("(min-width: 992px)").matches) {
            $dropdown.hover(
            function() {
                const $this = $(this);
                $this.addClass(showClass);
                $this.find($dropdownToggle).attr("aria-expanded", "true");
                $this.find($dropdownMenu).addClass(showClass);
            },
            function() {
                const $this = $(this);
                $this.removeClass(showClass);
                $this.find($dropdownToggle).attr("aria-expanded", "false");
                $this.find($dropdownMenu).removeClass(showClass);
            }
            );
        } else {
            $dropdown.off("mouseenter mouseleave");
        }
    });
    
    
    // Back to top button
    $(window).scroll(function () {
        if ($(this).scrollTop() > 300) {
            $('.back-to-top').fadeIn('slow');
        } else {
            $('.back-to-top').fadeOut('slow');
        }
    });
    $('.back-to-top').click(function () {
        $('html, body').animate({scrollTop: 0}, 1500, 'easeInOutExpo');
        return false;
    });


    // Facts counter
    $('[data-toggle="counter-up"]').counterUp({
        delay: 10,
        time: 2000
    });


    // Modal Video
    $(document).ready(function () {
        var $videoSrc;
        $('.btn-play').click(function () {
            $videoSrc = $(this).data("src");
        });
        console.log($videoSrc);

        $('#videoModal').on('shown.bs.modal', function (e) {
            $("#video").attr('src', $videoSrc + "?autoplay=1&amp;modestbranding=1&amp;showinfo=0");
        })

        $('#videoModal').on('hide.bs.modal', function (e) {
            $("#video").attr('src', $videoSrc);
        })
    });


    // Testimonials carousel
    $(".testimonial-carousel").owlCarousel({
        autoplay: true,
        smartSpeed: 1000,
        center: true,
        margin: 24,
        dots: true,
        loop: true,
        nav : false,
        responsive: {
            0:{
                items:1
            },
            768:{
                items:2
            },
            992:{
                items:2
            }
        }
    });
    
})(jQuery);

const images = document.querySelectorAll('.gallery-grid img');
    const modal = document.getElementById('modal');
    const modalImg = document.getElementById('modal-img');
    let currentIndex = 0;
    let imageSources = [];

    images.forEach((img, index) => {
      imageSources.push(img.src);
      img.addEventListener('click', () => {
        currentIndex = index;
        openModal();
      });
    });

    function openModal() {
      modal.style.display = 'flex';
      showImageWithAnimation();
    }

    function closeModal() {
      modal.style.display = 'none';
    }

    function prevImage() {
      currentIndex = (currentIndex - 1 + imageSources.length) % imageSources.length;
      showImageWithAnimation('left');
    }

    function nextImage() {
      currentIndex = (currentIndex + 1) % imageSources.length;
      showImageWithAnimation('right');
    }

    function showImageWithAnimation(direction = 'right') {
      modalImg.classList.add('slide-in');
      setTimeout(() => {
        modalImg.src = imageSources[currentIndex];
        modalImg.style.transform = `translateX(${direction === 'right' ? '50px' : '-50px'})`;
        modalImg.style.opacity = '0';
        void modalImg.offsetWidth; // trigger reflow
        modalImg.style.transform = 'translateX(0)';
        modalImg.style.opacity = '1';
        modalImg.classList.remove('slide-in');
      }, 100);
    }

    // Close modal when clicking outside the image
    modal.addEventListener('click', (e) => {
      if (e.target === modal) closeModal();
    });

    // Optional: keyboard navigation
    document.addEventListener('keydown', (e) => {
      if (modal.style.display === 'flex') {
        if (e.key === 'ArrowRight') nextImage();
        if (e.key === 'ArrowLeft') prevImage();
        if (e.key === 'Escape') closeModal();
      }
    });

document.querySelectorAll('.nav-link').forEach(link => {
    link.addEventListener('click', function (e) {
        // e.preventDefault(); // prevent the default jump
    
        const targetId = this.getAttribute('href').substring(1); // remove the #
        const targetElement = document.getElementById(targetId);
    
        if (targetElement) {
        targetElement.scrollIntoView({
            behavior: 'smooth'
        });
        }
    });
});
    



 document.addEventListener('DOMContentLoaded', function () {
    const navLinks = document.querySelectorAll('.navbar-nav .nav-link');
    const navbarCollapse = document.querySelector('.navbar-collapse');

    navLinks.forEach(function (link) {
      link.addEventListener('click', function () {
        if (window.innerWidth < 992) { // Only collapse on mobile
          const bsCollapse = bootstrap.Collapse.getInstance(navbarCollapse);
          if (bsCollapse) {
            bsCollapse.hide();
          }
        }
      });
    });
  });